/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.function.Consumer;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.log.ConsoleLogEntry;
import org.openqa.selenium.bidi.log.JavascriptLogEntry;
import org.openqa.selenium.bidi.module.LogInspector;
import org.openqa.selenium.remote.Script;

@Beta
class RemoteScript
implements Script {
    private final BiDi biDi;
    private final LogInspector logInspector;

    public RemoteScript(WebDriver driver) {
        this.biDi = ((HasBiDi)driver).getBiDi();
        this.logInspector = new LogInspector(driver);
    }

    @Override
    public long addConsoleMessageHandler(Consumer<ConsoleLogEntry> consumer) {
        return this.logInspector.onConsoleEntry(consumer);
    }

    @Override
    public void removeConsoleMessageHandler(long id) {
        this.biDi.removeListener(id);
    }

    @Override
    public long addJavaScriptErrorHandler(Consumer<JavascriptLogEntry> consumer) {
        return this.logInspector.onJavaScriptException(consumer);
    }

    @Override
    public void removeJavaScriptErrorHandler(long id) {
        this.biDi.removeListener(id);
    }
}

