/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing;

import java.util.Arrays;
import org.openqa.selenium.internal.Require;

public class EventAttributeValue {
    private final Type type;
    private String stringValue;
    private Number numberValue;
    private boolean booleanValue;
    private String[] stringArrayValue;
    private long[] longArrayValue;
    private double[] doubleArrayValue;
    private boolean[] booleanArrayValue;

    public EventAttributeValue(String value) {
        this.stringValue = value;
        this.type = Type.STRING;
    }

    public EventAttributeValue(long value) {
        this.numberValue = value;
        this.type = Type.LONG;
    }

    public EventAttributeValue(double value) {
        this.numberValue = value;
        this.type = Type.DOUBLE;
    }

    public EventAttributeValue(boolean value) {
        this.booleanValue = value;
        this.type = Type.BOOLEAN;
    }

    public EventAttributeValue(String[] value) {
        Require.nonNull((String)"Value", (Object)value);
        this.stringArrayValue = Arrays.copyOf(value, value.length);
        this.type = Type.STRING_ARRAY;
    }

    public EventAttributeValue(long[] value) {
        Require.nonNull((String)"Value", (Object)value);
        this.longArrayValue = Arrays.copyOf(value, value.length);
        this.type = Type.LONG_ARRAY;
    }

    public EventAttributeValue(double[] value) {
        Require.nonNull((String)"Value", (Object)value);
        this.doubleArrayValue = Arrays.copyOf(value, value.length);
        this.type = Type.DOUBLE_ARRAY;
    }

    public EventAttributeValue(boolean[] value) {
        Require.nonNull((String)"Value", (Object)value);
        this.booleanArrayValue = Arrays.copyOf(value, value.length);
        this.type = Type.BOOLEAN_ARRAY;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public Number getNumberValue() {
        return this.numberValue;
    }

    public Boolean getBooleanValue() {
        return this.booleanValue;
    }

    public String[] getStringArrayValue() {
        return Arrays.copyOf(this.stringArrayValue, this.stringArrayValue.length);
    }

    public long[] getLongArrayValue() {
        return Arrays.copyOf(this.longArrayValue, this.longArrayValue.length);
    }

    public double[] getDoubleArrayValue() {
        return Arrays.copyOf(this.doubleArrayValue, this.doubleArrayValue.length);
    }

    public boolean[] getBooleanArrayValue() {
        return Arrays.copyOf(this.booleanArrayValue, this.booleanArrayValue.length);
    }

    public Type getAttributeType() {
        return this.type;
    }

    public static enum Type {
        BOOLEAN,
        BOOLEAN_ARRAY,
        DOUBLE,
        DOUBLE_ARRAY,
        LONG,
        LONG_ARRAY,
        STRING,
        STRING_ARRAY;

    }
}

