/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.io.CountingOutputStream;
import com.google.common.io.FileBackedOutputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.InitialHandshakeResponse;
import org.openqa.selenium.remote.JsonWireProtocolResponse;
import org.openqa.selenium.remote.NewSessionPayload;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.W3CHandshakeResponse;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class ProtocolHandshake {
    private static final Logger LOG = Logger.getLogger(ProtocolHandshake.class.getName());

    public Result createSession(HttpHandler client, Command command) throws IOException {
        Capabilities desired = (Capabilities)command.getParameters().get("desiredCapabilities");
        desired = desired == null ? new ImmutableCapabilities() : desired;
        int threshold = (int)Math.min(Runtime.getRuntime().freeMemory() / 10L, Integer.MAX_VALUE);
        FileBackedOutputStream os = new FileBackedOutputStream(threshold);
        try (CountingOutputStream counter = new CountingOutputStream((OutputStream)os);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)counter, StandardCharsets.UTF_8);
             NewSessionPayload payload = NewSessionPayload.create(desired);){
            payload.writeTo(writer);
            try (InputStream rawIn = os.asByteSource().openBufferedStream();
                 BufferedInputStream contentStream = new BufferedInputStream(rawIn);){
                Either<Result, String> result = this.createSession(client, contentStream, counter.getCount());
                if (result.isLeft()) {
                    Result toReturn = (Result)result.left();
                    LOG.info(String.format("Detected dialect: %s", new Object[]{toReturn.dialect}));
                    Result result2 = toReturn;
                    return result2;
                }
                throw new SessionNotCreatedException(String.format("Unable to create new remote session. Reason: %s, desired capabilities = %s", result.right(), desired));
            }
        }
        finally {
            os.reset();
        }
    }

    Either<Result, String> createSession(HttpHandler client, InputStream newSessionBlob, long size) {
        Map blob;
        HttpRequest request = new HttpRequest(HttpMethod.POST, "/session");
        long start = System.currentTimeMillis();
        request.setHeader("Content-Length", String.valueOf(size));
        request.setHeader("Content-Type", "application/json; charset=utf-8");
        request.setContent(() -> newSessionBlob);
        HttpResponse response = client.execute(request);
        long time = System.currentTimeMillis() - start;
        try {
            blob = (Map)new Json().toType(Contents.string((HttpMessage)response), Map.class);
        }
        catch (JsonException e) {
            throw new WebDriverException("Unable to parse remote response: " + Contents.string((HttpMessage)response), (Throwable)e);
        }
        InitialHandshakeResponse initialResponse = new InitialHandshakeResponse(time, response.getStatus(), blob);
        if (initialResponse.getStatusCode() != 200) {
            return Either.right((Object)blob.get("message").toString());
        }
        return Stream.of(new W3CHandshakeResponse().getResponseFunction(), new JsonWireProtocolResponse().getResponseFunction()).map(func -> (Result)func.apply(initialResponse)).filter(Objects::nonNull).findFirst().map(Either::left).orElseGet(() -> Either.right((Object)"Handshake response does not match any supported protocol"));
    }

    public static class Result {
        private static final Function<Object, Proxy> massageProxy = obj -> {
            if (obj instanceof Proxy) {
                return (Proxy)obj;
            }
            if (!(obj instanceof Map)) {
                return null;
            }
            Map rawMap = (Map)obj;
            for (Object key : rawMap.keySet()) {
                if (key instanceof String) continue;
                return null;
            }
            return new Proxy((Map)obj);
        };
        private final Dialect dialect;
        private final Map<String, ?> capabilities;
        private final SessionId sessionId;

        Result(Dialect dialect, String sessionId, Map<String, ?> capabilities) {
            this.dialect = dialect;
            this.sessionId = new SessionId((String)Require.nonNull((String)"Session id", (Object)sessionId));
            this.capabilities = capabilities;
            if (capabilities.containsKey("proxy")) {
                capabilities.put("proxy", massageProxy.apply(capabilities.get("proxy")));
            }
        }

        public Dialect getDialect() {
            return this.dialect;
        }

        public Response createResponse() {
            Response response = new Response(this.sessionId);
            response.setValue(this.capabilities);
            response.setStatus(0);
            response.setState("success");
            return response;
        }

        public String toString() {
            return String.format("%s: %s", new Object[]{this.dialect, this.capabilities});
        }
    }
}

