/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.reactor;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpClientName;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Message;
import org.openqa.selenium.remote.http.TextMessage;
import org.openqa.selenium.remote.http.WebSocket;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.websocket.WebsocketOutbound;
import reactor.util.function.Tuple2;

public class ReactorClient
implements HttpClient {
    private static final Logger log = Logger.getLogger(ReactorClient.class.getName());
    private static final Map<HttpMethod, io.netty.handler.codec.http.HttpMethod> methodMap = ImmutableMap.of((Object)HttpMethod.DELETE, (Object)io.netty.handler.codec.http.HttpMethod.DELETE, (Object)HttpMethod.GET, (Object)io.netty.handler.codec.http.HttpMethod.GET, (Object)HttpMethod.POST, (Object)io.netty.handler.codec.http.HttpMethod.POST);
    private static final int MAX_CHUNK_SIZE = 524288;
    private final ClientConfig config;
    private final reactor.netty.http.client.HttpClient httpClient;

    private ReactorClient(ClientConfig config) {
        this.config = config;
        this.httpClient = reactor.netty.http.client.HttpClient.create().baseUrl(config.baseUrl().toString()).keepAlive(true);
    }

    public HttpResponse execute(HttpRequest request) {
        Tuple2 result = (Tuple2)((HttpClient.RequestSender)this.httpClient.headers(h -> request.getHeaderNames().forEach(name -> request.getHeaders(name).forEach(value -> h.set(name, value)))).request(methodMap.get(request.getMethod())).uri(request.getUri())).send((r, out) -> out.send(this.fromInputStream((InputStream)request.getContent().get()))).responseSingle((res, buf) -> {
            HttpResponse toReturn = new HttpResponse();
            toReturn.setStatus(res.status().code());
            res.responseHeaders().entries().forEach(entry -> toReturn.addHeader((String)entry.getKey(), (String)entry.getValue()));
            return buf.asInputStream().switchIfEmpty(Mono.just((Object)new ByteArrayInputStream("".getBytes()))).zipWith(Mono.just((Object)toReturn));
        }).block();
        ((HttpResponse)result.getT2()).setContent(() -> ((Tuple2)result).getT1());
        return (HttpResponse)result.getT2();
    }

    private Flux<ByteBuf> fromInputStream(InputStream is) {
        ByteBufAllocator allocator = ByteBufAllocator.DEFAULT;
        return Flux.generate(() -> is, (in, sync) -> {
            ByteBuf buf = allocator.buffer();
            try {
                if (buf.writeBytes(in, 524288) < 0) {
                    buf.release();
                    sync.complete();
                } else {
                    sync.next((Object)buf);
                }
            }
            catch (IOException ex) {
                buf.release();
                sync.error((Throwable)ex);
            }
            return in;
        }, in -> {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                log.log(Level.INFO, e.getMessage(), e);
            }
        });
    }

    public WebSocket openSocket(HttpRequest request, WebSocket.Listener listener) {
        Require.nonNull((String)"Request to send", (Object)request);
        Require.nonNull((String)"WebSocket listener", (Object)listener);
        try {
            URI origUri = new URI(request.getUri());
            URI wsUri = new URI("ws", null, origUri.getHost(), origUri.getPort(), origUri.getPath(), null, null);
            return new ReactorWebSocket((HttpClient.WebsocketSender)this.httpClient.headers(h -> request.getHeaderNames().forEach(name -> request.getHeaders(name).forEach(value -> h.set(name, value)))).websocket().uri(wsUri.toString()), listener);
        }
        catch (URISyntaxException e) {
            log.log(Level.INFO, e.getMessage(), e);
            return null;
        }
    }

    private static class ReactorWebSocket
    implements WebSocket {
        private WebsocketOutbound out;

        ReactorWebSocket(HttpClient.WebsocketSender websocket, WebSocket.Listener listener) {
            Flux response = websocket.handle((in, out) -> {
                this.out = out;
                return in.receive().asString();
            });
            response.subscribe(arg_0 -> ((WebSocket.Listener)listener).onText(arg_0));
        }

        public WebSocket send(Message message) {
            TextMessage txt = (TextMessage)message;
            this.out.sendString((Publisher)Flux.just((Object)txt.text())).then().subscribe();
            return this;
        }

        public void close() {
            this.out.sendClose().then().subscribe();
        }
    }

    @HttpClientName(value="reactor")
    public static class Factory
    implements HttpClient.Factory {
        public HttpClient createClient(ClientConfig config) {
            return new ReactorClient((ClientConfig)Require.nonNull((String)"Client config", (Object)config));
        }
    }
}

