/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.io.ByteStreams;
import com.google.common.io.FileBackedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Supplier;
import org.openqa.selenium.remote.http.HttpMessage;

public class Contents {
    private Contents() {
    }

    public static Supplier<InputStream> empty() {
        return Contents.bytes(new byte[0]);
    }

    public static Supplier<InputStream> utf8String(CharSequence value) {
        Objects.requireNonNull(value, "Value to return must be set.");
        return Contents.string(value, StandardCharsets.UTF_8);
    }

    public static Supplier<InputStream> string(CharSequence value, Charset charset) {
        Objects.requireNonNull(value, "Value to return must be set.");
        Objects.requireNonNull(charset, "Character set to use must be set.");
        return Contents.bytes(value.toString().getBytes(charset));
    }

    public static Supplier<InputStream> bytes(byte[] bytes) {
        Objects.requireNonNull(bytes, "Bytes to return must be set but may be empty.");
        return () -> new ByteArrayInputStream(bytes);
    }

    /*
     * Exception decompiling
     */
    public static byte[] bytes(Supplier<InputStream> supplier) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String utf8String(Supplier<InputStream> supplier) {
        return Contents.string(supplier, StandardCharsets.UTF_8);
    }

    public static String string(Supplier<InputStream> supplier, Charset charset) {
        Objects.requireNonNull(supplier, "Supplier of input must be set.");
        Objects.requireNonNull(charset, "Character set to use must be set.");
        return new String(Contents.bytes(supplier), charset);
    }

    public static String string(HttpMessage<?> message) {
        return Contents.string(message.getContent(), message.getContentEncoding());
    }

    public static Reader utf8Reader(Supplier<InputStream> supplier) {
        Objects.requireNonNull(supplier, "Supplier of input must be set.");
        return Contents.reader(supplier, StandardCharsets.UTF_8);
    }

    public static Reader reader(Supplier<InputStream> supplier, Charset charset) {
        Objects.requireNonNull(supplier, "Supplier of input must be set.");
        Objects.requireNonNull(charset, "Character set to use must be set.");
        return new InputStreamReader(supplier.get(), charset);
    }

    public static Reader reader(HttpMessage<?> message) {
        return Contents.reader(message.getContent(), message.getContentEncoding());
    }

    public static Supplier<InputStream> memoize(Supplier<InputStream> delegate) {
        return new MemoizedSupplier(delegate);
    }

    private static final class MemoizedSupplier
    implements Supplier<InputStream> {
        private volatile boolean initialized;
        private volatile FileBackedOutputStream fos;
        private Supplier<InputStream> delegate;

        private MemoizedSupplier(Supplier<InputStream> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputStream get() {
            if (!this.initialized) {
                MemoizedSupplier memoizedSupplier = this;
                synchronized (memoizedSupplier) {
                    if (!this.initialized) {
                        try (InputStream is = this.delegate.get();){
                            this.fos = new FileBackedOutputStream(0x300000, true);
                            ByteStreams.copy((InputStream)is, (OutputStream)this.fos);
                            this.initialized = true;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                        finally {
                            try {
                                this.fos.close();
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        }
                    }
                }
            }
            try {
                return Objects.requireNonNull(this.fos.asByteSource()).openBufferedStream();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

