/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.profiler.model;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.profiler.model.CoverageRange;
import org.openqa.selenium.json.JsonInput;

public class FunctionCoverage {
    private final String functionName;
    private final List<CoverageRange> ranges;
    private final Boolean isBlockCoverage;

    public FunctionCoverage(String functionName, List<CoverageRange> ranges, Boolean isBlockCoverage) {
        this.validateRanges(ranges);
        Objects.requireNonNull(functionName, "functionName is require");
        this.functionName = functionName;
        this.ranges = ranges;
        this.isBlockCoverage = isBlockCoverage;
    }

    private static FunctionCoverage fromJson(JsonInput input) {
        String functionName = null;
        ArrayList ranges = null;
        Boolean isBlockCoverage = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "functionName": {
                    functionName = input.nextString();
                    continue block10;
                }
                case "ranges": {
                    ranges = new ArrayList();
                    input.beginArray();
                    while (input.hasNext()) {
                        ranges.add(input.read((Type)((Object)CoverageRange.class)));
                    }
                    input.endArray();
                    continue block10;
                }
                case "isBlockCoverage": {
                    isBlockCoverage = input.nextBoolean();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FunctionCoverage(functionName, ranges, isBlockCoverage);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<CoverageRange> getRanges() {
        return this.ranges;
    }

    public void validateRanges(List<CoverageRange> ranges) {
        Objects.requireNonNull(ranges, "ranges is require");
        if (ranges.isEmpty()) {
            throw new DevToolsException("ranges is require");
        }
    }

    public boolean isBlockCoverage() {
        return this.isBlockCoverage;
    }
}

