/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Objects;
import org.openqa.selenium.devtools.network.model.MonotonicTime;
import org.openqa.selenium.devtools.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

public class WebSocketFrameError {
    private final RequestId requestId;
    private final MonotonicTime monotonicTime;
    private final String errorMessage;

    private WebSocketFrameError(RequestId requestId, MonotonicTime monotonicTime, String errorMessage) {
        this.requestId = Objects.requireNonNull(requestId, "'requestId' is required for WebSocketFrameError");
        this.monotonicTime = Objects.requireNonNull(monotonicTime, "'monotonicTime' is required for WebSocketFrameError");
        this.errorMessage = Objects.requireNonNull(errorMessage, "'errorMessage' is required for WebSocketFrameError");
    }

    private static WebSocketFrameError fromJson(JsonInput input) {
        RequestId requestId = new RequestId(input.nextString());
        MonotonicTime monotonicTime = null;
        String errorMessage = null;
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "monotonicTime": {
                    monotonicTime = MonotonicTime.parse(input.nextNumber());
                    continue block8;
                }
                case "errorMessage": {
                    errorMessage = input.nextString();
                    continue block8;
                }
            }
            input.skipValue();
        }
        return new WebSocketFrameError(requestId, monotonicTime, errorMessage);
    }
}

