/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.devtools.network.model.LoaderId;
import org.openqa.selenium.devtools.network.model.MonotonicTime;
import org.openqa.selenium.devtools.network.model.RequestId;
import org.openqa.selenium.devtools.network.model.ResourceType;
import org.openqa.selenium.devtools.network.model.Response;
import org.openqa.selenium.json.JsonInput;

public class ResponseReceived {
    private final RequestId requestId;
    private final LoaderId loaderId;
    private final MonotonicTime timestamp;
    private final ResourceType type;
    private final Response response;
    private final String frameId;

    private ResponseReceived(RequestId requestId, LoaderId loaderId, MonotonicTime timestamp, ResourceType type, Response response, String frameId) {
        this.requestId = Objects.requireNonNull(requestId, "'requestId' is required for ResponseReceived");
        this.loaderId = Objects.requireNonNull(loaderId, "'loaderId' is required for ResponseReceived");
        this.timestamp = Objects.requireNonNull(timestamp, "'timestamp' is required for ResponseReceived");
        this.type = Objects.requireNonNull(type, "'type' is required for ResponseReceived");
        this.response = Objects.requireNonNull(response, "'response' is required for ResponseReceived");
        this.frameId = frameId;
    }

    private static ResponseReceived fromJson(JsonInput input) {
        RequestId requestId = new RequestId(input.nextString());
        LoaderId loaderId = null;
        MonotonicTime timestamp = null;
        ResourceType type = null;
        Response response = null;
        String frameId = null;
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "loaderId": {
                    loaderId = new LoaderId(input.nextString());
                    continue block14;
                }
                case "timestamp": {
                    timestamp = MonotonicTime.parse(input.nextNumber());
                    continue block14;
                }
                case "response": {
                    response = (Response)input.read((Type)((Object)Response.class));
                    continue block14;
                }
                case "type": {
                    type = ResourceType.valueOf(input.nextString());
                    continue block14;
                }
                case "frameId": {
                    frameId = input.nextString();
                    continue block14;
                }
            }
            input.skipValue();
        }
        return new ResponseReceived(requestId, loaderId, timestamp, type, response, frameId);
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public LoaderId getLoaderId() {
        return this.loaderId;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public ResourceType getType() {
        return this.type;
    }

    public Response getResponse() {
        return this.response;
    }

    public String getFrameId() {
        return this.frameId;
    }

    public String toString() {
        return "ResponseReceived{requestId=" + this.requestId + ", loaderId=" + this.loaderId + ", timestamp=" + this.timestamp.getTimeStamp().toString() + ", type=" + (Object)((Object)this.type) + ", response=" + this.response + ", frameId='" + this.frameId + '\'' + '}';
    }
}

