/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.json.JsonInput;

public class Target {
    private static final Type SET_OF_TARGETINFO = new TypeToken<Set<TargetInfo>>(){}.getType();

    private Target() {
    }

    public static Command<Set<TargetInfo>> getTargets() {
        return new Command<Set<TargetInfo>>("Target.getTargets", (Map<String, Object>)ImmutableMap.of(), ConverterFunctions.map("targetInfos", SET_OF_TARGETINFO));
    }

    public static Command<SessionId> attachToTarget(TargetId targetId) {
        Objects.requireNonNull(targetId, "Target ID must be set.");
        return new Command<SessionId>("Target.attachToTarget", (Map<String, Object>)ImmutableMap.of((Object)"targetId", (Object)targetId, (Object)"flatten", (Object)true), ConverterFunctions.map("sessionId", SessionId.class));
    }

    public static Command<Void> setAutoAttach(boolean autoAttach) {
        return new Command<Void>("Target.setAutoAttach", (Map<String, Object>)ImmutableMap.of((Object)"autoAttach", (Object)autoAttach, (Object)"waitForDebuggerOnStart", (Object)false), (Type)((Object)Void.class));
    }

    public static class TargetInfo {
        private final TargetId targetId;
        private final String type;
        private final String title;
        private final String url;
        private final boolean attached;

        public TargetInfo(TargetId id, String type, String title, String url, boolean attached) {
            this.targetId = Objects.requireNonNull(id);
            this.type = Objects.requireNonNull(type);
            this.title = Objects.requireNonNull(title);
            this.url = Objects.requireNonNull(url);
            this.attached = attached;
        }

        public TargetId getTargetId() {
            return this.targetId;
        }

        public String getType() {
            return this.type;
        }

        public String getTitle() {
            return this.title;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isAttached() {
            return this.attached;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TargetInfo)) {
                return false;
            }
            TargetInfo that = (TargetInfo)o;
            return this.attached == that.attached && this.targetId.equals(that.targetId) && this.type.equals(that.type) && this.title.equals(that.title) && this.url.equals(that.url);
        }

        public int hashCode() {
            return Objects.hash(this.targetId, this.type, this.title, this.url, this.attached);
        }

        public String toString() {
            return new StringJoiner(", ", TargetInfo.class.getSimpleName() + "[", "]").add("targetId=" + this.targetId).add("type='" + this.type + "'").add("title='" + this.title + "'").add("url='" + this.url + "'").add("attached=" + this.attached).toString();
        }

        private Map<String, Object> toJson() {
            return ImmutableMap.of((Object)"targetId", (Object)this.targetId, (Object)"type", (Object)this.type, (Object)"title", (Object)this.title, (Object)"url", (Object)this.url, (Object)"attached", (Object)this.attached);
        }

        private static TargetInfo fromJson(JsonInput input) {
            TargetId id = null;
            String type = null;
            String title = null;
            String url = null;
            boolean attached = false;
            input.beginObject();
            block14: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "attached": {
                        attached = input.nextBoolean();
                        continue block14;
                    }
                    case "targetId": {
                        id = (TargetId)input.read((Type)((Object)TargetId.class));
                        continue block14;
                    }
                    case "title": {
                        title = input.nextString();
                        continue block14;
                    }
                    case "type": {
                        type = input.nextString();
                        continue block14;
                    }
                    case "url": {
                        url = input.nextString();
                        continue block14;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new TargetInfo(id, type, title, url, attached);
        }
    }

    public static class SessionId {
        private final String id;

        public SessionId(String id) {
            this.id = Objects.requireNonNull(id, "Session ID must be set.");
        }

        public boolean equals(Object o) {
            if (!(o instanceof SessionId)) {
                return false;
            }
            SessionId that = (SessionId)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return this.id;
        }

        private static SessionId fromJson(String id) {
            return new SessionId(id);
        }

        private String toJson() {
            return this.id;
        }
    }

    public static class TargetId {
        private final String id;

        public TargetId(String id) {
            this.id = Objects.requireNonNull(id, "Target ID must be set.");
        }

        public boolean equals(Object o) {
            if (!(o instanceof TargetId)) {
                return false;
            }
            TargetId that = (TargetId)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return this.id;
        }

        private static TargetId fromJson(String id) {
            return new TargetId(id);
        }

        private String toJson() {
            return this.id;
        }
    }
}

