/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.Interaction;
import org.openqa.selenium.interactions.KeyInput;
import org.openqa.selenium.interactions.PointerInput;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.http.AbstractHttpCommandCodec;
import org.openqa.selenium.remote.internal.WebElementToJsonConverter;

public class W3CHttpCommandCodec
extends AbstractHttpCommandCodec {
    private final PointerInput mouse = new PointerInput(PointerInput.Kind.MOUSE, "mouse");
    private final KeyInput keyboard = new KeyInput("keyboard");

    public W3CHttpCommandCodec() {
        this.alias("getElementAttribute", "executeScript");
        this.alias("getElementLocation", "getElementRect");
        this.alias("getElementLocationOnceScrolledIntoView", "executeScript");
        this.alias("getElementSize", "getElementRect");
        this.alias("isElementDisplayed", "executeScript");
        this.alias("submitElement", "executeScript");
        this.defineCommand("executeScript", W3CHttpCommandCodec.post("/session/:sessionId/execute/sync"));
        this.defineCommand("executeAsyncScript", W3CHttpCommandCodec.post("/session/:sessionId/execute/async"));
        this.alias("getPageSource", "executeScript");
        this.alias("clearLocalStorage", "executeScript");
        this.alias("getLocalStorageKeys", "executeScript");
        this.alias("setLocalStorageItem", "executeScript");
        this.alias("removeLocalStorageItem", "executeScript");
        this.alias("getLocalStorageItem", "executeScript");
        this.alias("getLocalStorageSize", "executeScript");
        this.alias("clearSessionStorage", "executeScript");
        this.alias("getSessionStorageKey", "executeScript");
        this.alias("setSessionStorageItem", "executeScript");
        this.alias("removeSessionStorageItem", "executeScript");
        this.alias("getSessionStorageItem", "executeScript");
        this.alias("getSessionStorageSize", "executeScript");
        this.defineCommand("maximizeCurrentWindow", W3CHttpCommandCodec.post("/session/:sessionId/window/maximize"));
        this.defineCommand("getCurrentWindowSize", W3CHttpCommandCodec.get("/session/:sessionId/window/rect"));
        this.defineCommand("setCurrentWindowSize", W3CHttpCommandCodec.post("/session/:sessionId/window/rect"));
        this.alias("getWindowPosition", "getCurrentWindowSize");
        this.alias("setWindowPosition", "setCurrentWindowSize");
        this.defineCommand("getCurrentWindowHandle", W3CHttpCommandCodec.get("/session/:sessionId/window"));
        this.defineCommand("getWindowHandles", W3CHttpCommandCodec.get("/session/:sessionId/window/handles"));
        this.defineCommand("acceptAlert", W3CHttpCommandCodec.post("/session/:sessionId/alert/accept"));
        this.defineCommand("dismissAlert", W3CHttpCommandCodec.post("/session/:sessionId/alert/dismiss"));
        this.defineCommand("getAlertText", W3CHttpCommandCodec.get("/session/:sessionId/alert/text"));
        this.defineCommand("setAlertValue", W3CHttpCommandCodec.post("/session/:sessionId/alert/text"));
        this.defineCommand("getActiveElement", W3CHttpCommandCodec.get("/session/:sessionId/element/active"));
        this.defineCommand("actions", W3CHttpCommandCodec.post("/session/:sessionId/actions"));
        this.defineCommand("clearActionState", W3CHttpCommandCodec.delete("/session/:sessionId/actions"));
        this.alias("mouseClick", "actions");
        this.alias("mouseDoubleClick", "actions");
        this.alias("mouseButtonDown", "actions");
        this.alias("mouseButtonUp", "actions");
        this.alias("mouseMoveTo", "actions");
    }

    @Override
    protected Map<String, ?> amendParameters(String name, Map<String, ?> parameters) {
        switch (name) {
            case "mouseClick": {
                return ImmutableMap.builder().put((Object)"actions", (Object)ImmutableList.of((Object)new Sequence((InputSource)this.mouse, 0).addAction(this.mouse.createPointerDown(PointerInput.MouseButton.LEFT.asArg())).addAction(this.mouse.createPointerUp(PointerInput.MouseButton.LEFT.asArg())).toJson())).build();
            }
            case "mouseDoubleClick": {
                return ImmutableMap.builder().put((Object)"actions", (Object)ImmutableList.of((Object)new Sequence((InputSource)this.mouse, 0).addAction(this.mouse.createPointerDown(PointerInput.MouseButton.LEFT.asArg())).addAction(this.mouse.createPointerUp(PointerInput.MouseButton.LEFT.asArg())).addAction(this.mouse.createPointerDown(PointerInput.MouseButton.LEFT.asArg())).addAction(this.mouse.createPointerUp(PointerInput.MouseButton.LEFT.asArg())).toJson())).build();
            }
            case "findChildElement": 
            case "findChildElements": 
            case "findElement": 
            case "findElements": {
                String using = (String)parameters.get("using");
                String value = (String)parameters.get("value");
                HashMap toReturn = new HashMap(parameters);
                switch (using) {
                    case "class name": {
                        toReturn.put("using", "css selector");
                        toReturn.put("value", "." + this.cssEscape(value));
                        break;
                    }
                    case "id": {
                        toReturn.put("using", "css selector");
                        toReturn.put("value", "#" + this.cssEscape(value));
                        break;
                    }
                    case "link text": {
                        break;
                    }
                    case "name": {
                        toReturn.put("using", "css selector");
                        toReturn.put("value", "*[name='" + value + "']");
                        break;
                    }
                    case "partial link text": {
                        break;
                    }
                    case "tag name": {
                        toReturn.put("using", "css selector");
                        toReturn.put("value", this.cssEscape(value));
                        break;
                    }
                }
                return toReturn;
            }
            case "getElementAttribute": {
                return this.executeAtom("getAttribute.js", this.asElement(parameters.get("id")), parameters.get("name"));
            }
            case "getElementLocationOnceScrolledIntoView": {
                return this.toScript("var e = arguments[0]; e.scrollIntoView({behavior: 'instant', block: 'end', inline: 'nearest'}); var rect = e.getBoundingClientRect(); return {'x': rect.left, 'y': rect.top};", this.asElement(parameters.get("id")));
            }
            case "getPageSource": {
                return this.toScript("var source = document.documentElement.outerHTML; \nif (!source) { source = new XMLSerializer().serializeToString(document); }\nreturn source;", new Object[0]);
            }
            case "clearLocalStorage": {
                return this.toScript("localStorage.clear()", new Object[0]);
            }
            case "getLocalStorageKeys": {
                return this.toScript("return Object.keys(localStorage)", new Object[0]);
            }
            case "setLocalStorageItem": {
                return this.toScript("localStorage.setItem('arguments[0]', 'arguments[1]')", new Object[0]);
            }
            case "removeLocalStorageItem": {
                return this.toScript("localStorage.removeItem('arguments[0]')", new Object[0]);
            }
            case "getLocalStorageItem": {
                return this.toScript("return localStorage.getItem('arguments[0]')", new Object[0]);
            }
            case "getLocalStorageSize": {
                return this.toScript("return localStorage.length", new Object[0]);
            }
            case "clearSessionStorage": {
                return this.toScript("sessionStorage.clear()", new Object[0]);
            }
            case "getSessionStorageKey": {
                return this.toScript("return Object.keys(sessionStorage)", new Object[0]);
            }
            case "setSessionStorageItem": {
                return this.toScript("sessionStorage.setItem('arguments[0]', 'arguments[1]')", new Object[0]);
            }
            case "removeSessionStorageItem": {
                return this.toScript("sessionStorage.removeItem('arguments[0]')", new Object[0]);
            }
            case "getSessionStorageItem": {
                return this.toScript("return sessionStorage.getItem('arguments[0]')", new Object[0]);
            }
            case "getSessionStorageSize": {
                return this.toScript("return sessionStorage.length", new Object[0]);
            }
            case "isElementDisplayed": {
                return this.executeAtom("isDisplayed.js", this.asElement(parameters.get("id")));
            }
            case "mouseButtonDown": {
                Interaction mouseDown = this.mouse.createPointerDown(PointerInput.MouseButton.LEFT.asArg());
                return ImmutableMap.builder().put((Object)"actions", (Object)ImmutableList.of((Object)new Sequence((InputSource)this.mouse, 0).addAction(mouseDown).toJson())).build();
            }
            case "mouseButtonUp": {
                Interaction mouseUp = this.mouse.createPointerUp(PointerInput.MouseButton.LEFT.asArg());
                return ImmutableMap.builder().put((Object)"actions", (Object)ImmutableList.of((Object)new Sequence((InputSource)this.mouse, 0).addAction(mouseUp).toJson())).build();
            }
            case "mouseMoveTo": {
                PointerInput.Origin origin = PointerInput.Origin.pointer();
                if (parameters.containsKey("element")) {
                    RemoteWebElement element = new RemoteWebElement();
                    element.setId((String)parameters.get("element"));
                    origin = PointerInput.Origin.fromElement(element);
                }
                int x = parameters.containsKey("xoffset") ? ((Number)parameters.get("xoffset")).intValue() : 0;
                int y = parameters.containsKey("yoffset") ? ((Number)parameters.get("yoffset")).intValue() : 0;
                Interaction mouseMove = this.mouse.createPointerMove(Duration.ofMillis(200L), origin, x, y);
                return ImmutableMap.builder().put((Object)"actions", (Object)ImmutableList.of((Object)new Sequence((InputSource)this.mouse, 0).addAction(mouseMove).toJson())).build();
            }
            case "sendKeysToActiveElement": 
            case "sendKeysToElement": {
                Object rawValue = parameters.get("value");
                Stream<Object> source = rawValue instanceof Collection ? ((Collection)rawValue).stream() : Stream.of((CharSequence[])rawValue);
                String text = source.flatMap(Stream::of).collect(Collectors.joining());
                return ImmutableMap.builder().putAll(parameters.entrySet().stream().filter(e -> !"text".equals(e.getKey())).filter(e -> !"value".equals(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).put((Object)"text", (Object)text).put((Object)"value", this.stringToUtf8Array(text)).build();
            }
            case "setAlertValue": {
                return ImmutableMap.builder().put((Object)"text", parameters.get("text")).put((Object)"value", this.stringToUtf8Array((String)parameters.get("text"))).build();
            }
            case "setTimeout": {
                String timeoutType = (String)parameters.get("type");
                Number duration = (Number)parameters.get("ms");
                if (timeoutType == null) {
                    return parameters;
                }
                return ImmutableMap.builder().putAll(parameters.entrySet().stream().filter(e -> !timeoutType.equals(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).put((Object)timeoutType, (Object)duration).build();
            }
            case "submitElement": {
                return this.toScript("var form = arguments[0];\nwhile (form.nodeName != \"FORM\" && form.parentNode) {\n  form = form.parentNode;\n}\nif (!form) { throw Error('Unable to find containing form element'); }\nif (!form.ownerDocument) { throw Error('Unable to find owning document'); }\nvar e = form.ownerDocument.createEvent('Event');\ne.initEvent('submit', true, true);\nif (form.dispatchEvent(e)) { HTMLFormElement.prototype.submit.call(form) }\n", this.asElement(parameters.get("id")));
            }
        }
        return parameters;
    }

    private List<String> stringToUtf8Array(String toConvert) {
        int next;
        ArrayList<String> toReturn = new ArrayList<String>();
        for (int offset = 0; offset < toConvert.length(); offset += Character.charCount(next)) {
            next = toConvert.codePointAt(offset);
            toReturn.add(new StringBuilder().appendCodePoint(next).toString());
        }
        return toReturn;
    }

    private Map<String, ?> executeAtom(String atomFileName, Object ... args) {
        try {
            String scriptName = "/org/openqa/selenium/remote/" + atomFileName;
            URL url = this.getClass().getResource(scriptName);
            String rawFunction = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
            String script = String.format("return (%s).apply(null, arguments);", rawFunction);
            return this.toScript(script, args);
        }
        catch (IOException | NullPointerException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private Map<String, ?> toScript(String script, Object ... args) {
        script = script.replaceAll("\"", "\\\"");
        List convertedArgs = Stream.of(args).map(new WebElementToJsonConverter()).collect(Collectors.toList());
        return ImmutableMap.of((Object)"script", (Object)script, (Object)"args", convertedArgs);
    }

    private Map<String, String> asElement(Object id) {
        return ImmutableMap.of((Object)"element-6066-11e4-a52e-4f735466cecf", (Object)((String)id));
    }

    private String cssEscape(String using) {
        if ((using = using.replaceAll("([\\s'\"\\\\#.:;,!?+<>=~*^$|%&@`{}\\-\\/\\[\\]\\(\\)])", "\\\\$1")).length() > 0 && Character.isDigit(using.charAt(0))) {
            using = "\\" + Integer.toString(30 + Integer.parseInt(using.substring(0, 1))) + " " + using.substring(1);
        }
        return using;
    }
}

