/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.os;

import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.os.Kernel32;
import org.openqa.selenium.os.OsProcess;

@Beta
public class WindowsProcessGroup
implements OsProcess {
    private Kernel32 Kernel32 = org.openqa.selenium.os.Kernel32.INSTANCE;
    private String cmd;
    private WinNT.HANDLE hJob;
    private String workingDirectory = null;

    public WindowsProcessGroup(String executable, String ... args) {
        StringBuilder toExecute = new StringBuilder();
        toExecute.append(executable);
        boolean first = true;
        for (String arg : args) {
            toExecute.append(" ");
            toExecute.append(this.quote(arg));
        }
        this.cmd = toExecute.toString();
    }

    private String quote(String toQuote) {
        if (toQuote.indexOf(32) != -1) {
            return '\"' + toQuote + '\"';
        }
        return toQuote;
    }

    @Override
    public Map<String, String> getEnvironment() {
        throw new UnsupportedOperationException("getEnvironment");
    }

    @Override
    public void setEnvironmentVariable(String name, String value) {
        throw new UnsupportedOperationException("setEnvironmentVariable");
    }

    @Override
    public void copyOutputTo(OutputStream out) {
        throw new UnsupportedOperationException("copyOutputTo");
    }

    @Override
    public void setInput(String allInput) {
        throw new UnsupportedOperationException("setInput");
    }

    @Override
    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory.getAbsolutePath();
    }

    @Override
    public void executeAsync() {
        WinBase.STARTUPINFO si = new WinBase.STARTUPINFO();
        si.clear();
        WinBase.PROCESS_INFORMATION.ByReference pi = new WinBase.PROCESS_INFORMATION.ByReference();
        pi.clear();
        Kernel32.JOBJECT_EXTENDED_LIMIT_INFORMATION.ByReference jeli = new Kernel32.JOBJECT_EXTENDED_LIMIT_INFORMATION.ByReference();
        jeli.clear();
        this.hJob = this.Kernel32.CreateJobObject(null, null);
        if (this.hJob.getPointer() == null) {
            throw new WebDriverException("Cannot create job object");
        }
        jeli.BasicLimitInformation.LimitFlags = 0x800 | 0x2000;
        if (!this.Kernel32.SetInformationJobObject(this.hJob, 9, jeli.getPointer(), jeli.size())) {
            throw new WebDriverException("Unable to set information on the job object");
        }
        boolean result = this.Kernel32.CreateProcess(null, this.cmd, null, null, false, new WinDef.DWORD(0x1000004L), null, this.workingDirectory, si, pi);
        if (!result) {
            throw new WebDriverException("Failed to create the process");
        }
        if (!this.Kernel32.AssignProcessToJobObject(this.hJob, pi.hProcess)) {
            throw new WebDriverException("Cannot assign process to job: " + this.Kernel32.GetLastError());
        }
        if (this.Kernel32.ResumeThread(pi.hThread) == 0) {
            throw new WebDriverException("Cannot resume thread");
        }
        this.Kernel32.CloseHandle(pi.hThread);
        this.Kernel32.CloseHandle(pi.hProcess);
    }

    @Override
    public void waitFor() throws InterruptedException {
    }

    @Override
    public int destroy() {
        if (this.hJob == null) {
            return 0;
        }
        this.Kernel32.TerminateJobObject(this.hJob, 666L);
        this.Kernel32.CloseHandle(this.hJob);
        this.hJob = null;
        return 0;
    }

    @Override
    public int getExitCode() {
        return 0;
    }

    @Override
    public String getStdOut() {
        throw new UnsupportedOperationException("getStdOut");
    }
}

