/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.internal;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.remote.RemoteWebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebElementToJsonConverter
implements Function<Object, Object> {
    public Object apply(Object arg) {
        if (arg == null || arg instanceof String || arg instanceof Boolean || arg instanceof Number) {
            return arg;
        }
        if (arg instanceof WrapsElement) {
            arg = ((WrapsElement)arg).getWrappedElement();
        }
        if (arg instanceof RemoteWebElement) {
            return ImmutableMap.of((Object)"ELEMENT", (Object)((RemoteWebElement)arg).getId());
        }
        if (arg instanceof Collection) {
            Collection args = (Collection)arg;
            return Collections2.transform((Collection)args, (Function)this);
        }
        if (arg instanceof Map) {
            Map args = (Map)arg;
            HashMap converted = Maps.newHashMapWithExpectedSize((int)args.size());
            for (Map.Entry entry : args.entrySet()) {
                Object key = entry.getKey();
                if (!(key instanceof String)) {
                    throw new IllegalArgumentException("All keys in Map script arguments must be strings: " + key.getClass().getName());
                }
                converted.put((String)key, this.apply(entry.getValue()));
            }
            return converted;
        }
        throw new IllegalArgumentException("Argument is of an illegal type: " + arg.getClass().getName());
    }
}

