/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.Response;

public class RenderedRemoteWebElement
extends RemoteWebElement
implements RenderedWebElement,
Locatable {
    public boolean isDisplayed() {
        Response response = this.parent.execute("isElementDisplayed", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
        return (Boolean)response.getValue();
    }

    public Point getLocation() {
        Response response = this.parent.execute("getElementLocation", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
        Map rawPoint = (Map)response.getValue();
        int x = ((Long)rawPoint.get("x")).intValue();
        int y = ((Long)rawPoint.get("y")).intValue();
        return new Point(x, y);
    }

    public Dimension getSize() {
        Response response = this.parent.execute("getElementSize", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
        Map rawSize = (Map)response.getValue();
        int width = ((Long)rawSize.get("width")).intValue();
        int height = ((Long)rawSize.get("height")).intValue();
        return new Dimension(width, height);
    }

    public void dragAndDropBy(int moveRightBy, int moveDownBy) {
        this.parent.execute("dragElement", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"x", (Object)moveRightBy, (Object)"y", (Object)moveDownBy));
    }

    public void dragAndDropOn(RenderedWebElement element) {
        Point currentLocation = this.getLocation();
        Point destination = element.getLocation();
        this.dragAndDropBy(destination.x - currentLocation.x, destination.y - currentLocation.y);
    }

    public String getValueOfCssProperty(String propertyName) {
        Response response = this.parent.execute("getElementValueOfCssProperty", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"propertyName", (Object)propertyName));
        return (String)response.getValue();
    }

    public Point getLocationOnScreenOnceScrolledIntoView() {
        Response response = this.execute("getElementLocationOnceScrolledIntoView", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.getId()));
        Map mapped = (Map)response.getValue();
        return new Point(((Number)mapped.get("x")).intValue(), ((Number)mapped.get("y")).intValue());
    }

    public Coordinates getCoordinates() {
        return new Coordinates(){

            public Point getLocationOnScreen() {
                return RenderedRemoteWebElement.this.getLocationOnScreenOnceScrolledIntoView();
            }

            public Point getLocationInViewPort() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public Point getLocationInDOM() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public Object getAuxiliry() {
                return RenderedRemoteWebElement.this.getId();
            }
        };
    }
}

