/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.browserlaunchers;

import org.openqa.selenium.internal.NullTrace;
import org.openqa.selenium.internal.Trace;
import org.openqa.selenium.os.ProcessUtils;
import org.openqa.selenium.os.UnixUtils;
import org.openqa.selenium.os.WindowsUtils;

public class AsyncExecute {
    static Trace log = new NullTrace();

    public static void sleepTightInSeconds(long timeoutInSeconds) {
        AsyncExecute.sleepTight(timeoutInSeconds * 1000L);
    }

    public static void sleepTight(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static int killProcess(Process process) {
        int exitValue;
        process.destroy();
        try {
            exitValue = ProcessUtils.waitForProcessDeath(process, 10000L);
        }
        catch (ProcessUtils.ProcessStillAliveException ex) {
            if (WindowsUtils.thisIsWindows()) {
                throw ex;
            }
            try {
                log.info("Process didn't die after 10 seconds");
                UnixUtils.kill9(process);
                exitValue = ProcessUtils.waitForProcessDeath(process, 10000L);
            }
            catch (Exception e) {
                log.error("Process refused to die after 10 seconds, and couldn't kill9 it", (Throwable)e);
                throw new RuntimeException("Process refused to die after 10 seconds, and couldn't kill9 it: " + e.getMessage(), ex);
            }
        }
        return exitValue;
    }
}

