/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.opera;

import com.google.auto.service.AutoService;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.opera.OperaDriverService;

@AutoService(value={WebDriverInfo.class})
public class OperaDriverInfo
implements WebDriverInfo {
    public String getDisplayName() {
        return "Opera";
    }

    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", (Object)"operablink");
    }

    public boolean isSupporting(Capabilities capabilities) {
        return "operablink".equals(capabilities.getBrowserName()) || "opera".equals(capabilities.getBrowserName());
    }

    public boolean isSupportingCdp() {
        return false;
    }

    public boolean isAvailable() {
        try {
            OperaDriverService.createDefaultService();
            return true;
        }
        catch (IllegalStateException | WebDriverException e) {
            return false;
        }
    }

    public int getMaximumSimultaneousSessions() {
        return Runtime.getRuntime().availableProcessors() + 1;
    }

    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable()) {
            return Optional.empty();
        }
        return Optional.of(new OperaDriver(capabilities));
    }
}

