/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.manager;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.manager.SeleniumManagerOutput;
import org.openqa.selenium.os.CommandLine;

@Beta
public class SeleniumManager {
    private static final Logger LOG = Logger.getLogger(SeleniumManager.class.getName());
    private static final String SELENIUM_MANAGER = "selenium-manager";
    private static volatile SeleniumManager manager;
    private final String managerPath = System.getenv("SE_MANAGER_PATH");
    private Path binary;

    private SeleniumManager() {
        Path path = this.binary = this.managerPath == null ? null : Paths.get(this.managerPath, new String[0]);
        if (this.managerPath == null) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (this.binary != null && Files.exists(this.binary, new LinkOption[0])) {
                    try {
                        Files.delete(this.binary);
                    }
                    catch (IOException e) {
                        LOG.warning(String.format("%s deleting temporal file: %s", e.getClass().getSimpleName(), e.getMessage()));
                    }
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SeleniumManager getInstance() {
        if (manager != null) return manager;
        Class<SeleniumManager> clazz = SeleniumManager.class;
        synchronized (SeleniumManager.class) {
            if (manager != null) return manager;
            manager = new SeleniumManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    private static SeleniumManagerOutput.Result runCommand(Path binary, List<String> arguments) {
        String output;
        int code;
        LOG.fine(String.format("Executing Process: %s", arguments));
        try {
            CommandLine command = new CommandLine(binary.toAbsolutePath().toString(), arguments.toArray(new String[0]));
            command.executeAsync();
            command.waitFor();
            if (command.isRunning()) {
                LOG.warning("Selenium Manager did not exit");
            }
            code = command.getExitCode();
            output = command.getStdOut();
        }
        catch (Exception e) {
            throw new WebDriverException("Failed to run command: " + arguments, (Throwable)e);
        }
        SeleniumManagerOutput jsonOutput = null;
        JsonException failedToParse = null;
        String dump = output;
        if (!output.isEmpty()) {
            try {
                jsonOutput = (SeleniumManagerOutput)new Json().toType(output, SeleniumManagerOutput.class);
                jsonOutput.getLogs().forEach(logged -> {
                    Level currentLevel = logged.getLevel() == Level.INFO ? Level.FINE : logged.getLevel();
                    LOG.log(currentLevel, logged.getMessage());
                });
                dump = jsonOutput.getResult().getMessage();
            }
            catch (JsonException e) {
                failedToParse = e;
            }
        }
        if (code != 0) {
            throw new WebDriverException("Command failed with code: " + code + ", executed: " + arguments + "\n" + dump, (Throwable)failedToParse);
        }
        if (failedToParse != null || jsonOutput == null) {
            throw new WebDriverException("Failed to parse json output, executed: " + arguments + "\n" + dump, (Throwable)failedToParse);
        }
        return jsonOutput.getResult();
    }

    private synchronized Path getBinary() {
        block13: {
            if (this.binary == null) {
                Platform current = Platform.getCurrent();
                String folder = "linux";
                String extension = "";
                if (current.is(Platform.WINDOWS)) {
                    extension = ".exe";
                    folder = "windows";
                } else if (current.is(Platform.MAC)) {
                    folder = "macos";
                }
                String binaryPath = String.format("%s/%s%s", folder, SELENIUM_MANAGER, extension);
                try (InputStream inputStream = this.getClass().getResourceAsStream(binaryPath);){
                    Path tmpPath = Files.createTempDirectory(SELENIUM_MANAGER + System.nanoTime(), new FileAttribute[0]);
                    this.deleteOnExit(tmpPath);
                    this.binary = tmpPath.resolve(SELENIUM_MANAGER + extension);
                    Files.copy(inputStream, this.binary, StandardCopyOption.REPLACE_EXISTING);
                    break block13;
                }
                catch (Exception e) {
                    throw new WebDriverException("Unable to obtain Selenium Manager Binary", (Throwable)e);
                }
            }
            if (!Files.exists(this.binary, new LinkOption[0])) {
                throw new WebDriverException(String.format("Unable to obtain Selenium Manager Binary at: %s", this.binary));
            }
        }
        this.binary.toFile().setExecutable(true);
        LOG.fine(String.format("Selenium Manager binary found at: %s", this.binary));
        return this.binary;
    }

    private void deleteOnExit(Path tmpPath) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                Files.walkFileTree(tmpPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }));
    }

    private String getBrowserBinary(Capabilities options) {
        List<String> vendorOptionsCapabilities = Arrays.asList("moz:firefoxOptions", "goog:chromeOptions", "ms:edgeOptions");
        for (String vendorOptionsCapability : vendorOptionsCapabilities) {
            if (!options.asMap().containsKey(vendorOptionsCapability)) continue;
            try {
                Map vendorOptions = (Map)options.getCapability(vendorOptionsCapability);
                return (String)vendorOptions.get("binary");
            }
            catch (Exception e) {
                LOG.warning(String.format("Exception while retrieving the browser binary path. %s: %s", options, e.getMessage()));
            }
        }
        return null;
    }

    public SeleniumManagerOutput.Result getDriverPath(Capabilities options, boolean offline) {
        Proxy proxy;
        String browserBinary;
        Path binaryFile = this.getBinary();
        if (binaryFile == null) {
            return null;
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--browser");
        arguments.add(options.getBrowserName());
        arguments.add("--output");
        arguments.add("json");
        if (!options.getBrowserVersion().isEmpty()) {
            arguments.add("--browser-version");
            arguments.add(options.getBrowserVersion());
            if (options instanceof MutableCapabilities) {
                ((MutableCapabilities)options).setCapability("browserVersion", (String)null);
            }
        }
        if ((browserBinary = this.getBrowserBinary(options)) != null && !browserBinary.isEmpty()) {
            arguments.add("--browser-path");
            arguments.add(browserBinary);
        }
        if (this.getLogLevel().intValue() <= Level.FINE.intValue()) {
            arguments.add("--debug");
        }
        if (offline) {
            arguments.add("--offline");
        }
        if ((proxy = Proxy.extractFrom((Capabilities)options)) != null) {
            if (proxy.getSslProxy() != null) {
                arguments.add("--proxy");
                arguments.add(proxy.getSslProxy());
            } else if (proxy.getHttpProxy() != null) {
                arguments.add("--proxy");
                arguments.add(proxy.getHttpProxy());
            }
        }
        SeleniumManagerOutput.Result result = SeleniumManager.runCommand(binaryFile, arguments);
        LOG.fine(String.format("Using driver at location: %s, browser at location %s", result.getDriverPath(), result.getBrowserPath()));
        return result;
    }

    private Level getLogLevel() {
        Level level = LOG.getLevel();
        if (level == null && LOG.getParent() != null) {
            level = LOG.getParent().getLevel();
        }
        if (level == null) {
            return Level.INFO;
        }
        return level;
    }
}

