/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.manager;

import com.google.common.io.CharStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.manager.SeleniumManagerOutput;

@Beta
public class SeleniumManager {
    private static final Logger LOG = Logger.getLogger(SeleniumManager.class.getName());
    private static final String SELENIUM_MANAGER = "selenium-manager";
    private static final String EXE = ".exe";
    private static final String INFO = "INFO";
    private static final String WARN = "WARN";
    private static final String DEBUG = "DEBUG";
    private static volatile SeleniumManager manager;
    private File binary;

    private SeleniumManager() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (this.binary != null && this.binary.exists()) {
                try {
                    Files.delete(this.binary.toPath());
                }
                catch (IOException e) {
                    LOG.warning(String.format("%s deleting temporal file: %s", e.getClass().getSimpleName(), e.getMessage()));
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SeleniumManager getInstance() {
        if (manager != null) return manager;
        Class<SeleniumManager> clazz = SeleniumManager.class;
        synchronized (SeleniumManager.class) {
            if (manager != null) return manager;
            manager = new SeleniumManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    private static SeleniumManagerOutput.Result runCommand(String ... command) {
        String output;
        int code;
        LOG.fine(String.format("Executing Process: %s", Arrays.toString(command)));
        try {
            Process process = new ProcessBuilder(command).redirectErrorStream(true).start();
            process.waitFor();
            code = process.exitValue();
            output = CharStreams.toString((Readable)new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WebDriverException("Interrupted while running command: " + Arrays.toString(command), (Throwable)e);
        }
        catch (Exception e) {
            throw new WebDriverException("Failed to run command: " + Arrays.toString(command), (Throwable)e);
        }
        SeleniumManagerOutput jsonOutput = null;
        JsonException failedToParse = null;
        String dump = output;
        if (!output.isEmpty()) {
            try {
                jsonOutput = (SeleniumManagerOutput)new Json().toType(output, SeleniumManagerOutput.class);
                jsonOutput.logs.forEach(logged -> {
                    if (logged.level.equalsIgnoreCase(WARN)) {
                        LOG.warning(logged.message);
                    }
                    if (logged.level.equalsIgnoreCase(DEBUG) || logged.level.equalsIgnoreCase(INFO)) {
                        LOG.fine(logged.message);
                    }
                });
                dump = jsonOutput.result.message;
            }
            catch (JsonException e) {
                failedToParse = e;
            }
        }
        if (code != 0) {
            throw new WebDriverException("Command failed with code: " + code + ", executed: " + Arrays.toString(command) + "\n" + dump, (Throwable)failedToParse);
        }
        if (failedToParse != null || jsonOutput == null) {
            throw new WebDriverException("Failed to parse json output, executed: " + Arrays.toString(command) + "\n" + dump, (Throwable)failedToParse);
        }
        return jsonOutput.result;
    }

    private synchronized File getBinary() {
        if (this.binary == null) {
            try {
                Platform current = Platform.getCurrent();
                String folder = "linux";
                String extension = "";
                if (current.is(Platform.WINDOWS)) {
                    extension = EXE;
                    folder = "windows";
                } else if (current.is(Platform.MAC)) {
                    folder = "macos";
                }
                String binaryPath = String.format("%s/%s%s", folder, SELENIUM_MANAGER, extension);
                try (InputStream inputStream = this.getClass().getResourceAsStream(binaryPath);){
                    Path tmpPath = Files.createTempDirectory(SELENIUM_MANAGER + System.nanoTime(), new FileAttribute[0]);
                    File tmpFolder = tmpPath.toFile();
                    tmpFolder.deleteOnExit();
                    this.binary = new File(tmpFolder, SELENIUM_MANAGER + extension);
                    Files.copy(inputStream, this.binary.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                this.binary.setExecutable(true);
            }
            catch (Exception e) {
                throw new WebDriverException("Unable to obtain Selenium Manager Binary", (Throwable)e);
            }
        }
        LOG.fine(String.format("Selenium Manager binary found at: %s", this.binary));
        return this.binary;
    }

    private String getBrowserBinary(Capabilities options) {
        List<String> vendorOptionsCapabilities = Arrays.asList("moz:firefoxOptions", "goog:chromeOptions", "ms:edgeOptions");
        for (String vendorOptionsCapability : vendorOptionsCapabilities) {
            if (!options.asMap().containsKey(vendorOptionsCapability)) continue;
            try {
                Map vendorOptions = (Map)options.getCapability(vendorOptionsCapability);
                return (String)vendorOptions.get("binary");
            }
            catch (Exception e) {
                LOG.warning(String.format("Exception while retrieving the browser binary path. %s: %s", options, e.getMessage()));
            }
        }
        return null;
    }

    public SeleniumManagerOutput.Result getDriverPath(Capabilities options, boolean offline) {
        Proxy proxy;
        String browserBinary;
        File binaryFile = this.getBinary();
        if (binaryFile == null) {
            return null;
        }
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(binaryFile.getAbsolutePath());
        commandList.add("--browser");
        commandList.add(options.getBrowserName());
        commandList.add("--output");
        commandList.add("json");
        if (!options.getBrowserVersion().isEmpty()) {
            commandList.add("--browser-version");
            commandList.add(options.getBrowserVersion());
        }
        if ((browserBinary = this.getBrowserBinary(options)) != null && !browserBinary.isEmpty()) {
            commandList.add("--browser-path");
            commandList.add(browserBinary);
        }
        if (this.getLogLevel().intValue() <= Level.FINE.intValue()) {
            commandList.add("--debug");
        }
        if (offline) {
            commandList.add("--offline");
        }
        if ((proxy = (Proxy)options.getCapability("proxy")) != null) {
            if (proxy.getSslProxy() != null) {
                commandList.add("--proxy");
                commandList.add(proxy.getSslProxy());
            } else if (proxy.getHttpProxy() != null) {
                commandList.add("--proxy");
                commandList.add(proxy.getHttpProxy());
            }
        }
        SeleniumManagerOutput.Result result = SeleniumManager.runCommand(commandList.toArray(new String[0]));
        LOG.fine(String.format("Using driver at location: %s, browser at location %s", result.getDriverPath(), result.getBrowserPath()));
        return result;
    }

    private Level getLogLevel() {
        Level level = LOG.getLevel();
        if (level == null && LOG.getParent() != null) {
            level = LOG.getParent().getLevel();
        }
        if (level == null) {
            return Level.INFO;
        }
        return level;
    }
}

