/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.session.ActiveSession;
import org.openqa.selenium.grid.session.SessionFactory;
import org.openqa.selenium.grid.session.remote.ServicedSession;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.server.DefaultDriverProvider;
import org.openqa.selenium.remote.server.DriverProvider;
import org.openqa.selenium.remote.server.InMemorySession;
import org.openqa.selenium.remote.tracing.Tracer;

public class ActiveSessionFactory
implements SessionFactory {
    private static final Logger LOG = Logger.getLogger(ActiveSessionFactory.class.getName());
    private static final Function<String, Class<?>> CLASS_EXISTS = name -> {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    };
    private List<SessionFactory> factories;

    public ActiveSessionFactory(Tracer tracer) {
        ImmutableList.Builder builder = ImmutableList.builder();
        StreamSupport.stream(this.loadDriverProviders().spliterator(), false).forEach(p -> builder.add((Object)new InMemorySession.Factory((DriverProvider)p)));
        ImmutableMap.builder().put(caps -> {
            Object marionette = caps.getCapability("marionette");
            return marionette instanceof Boolean && (Boolean)marionette == false;
        }, (Object)"org.openqa.selenium.firefox.xpi.XpiDriverService").put(ActiveSessionFactory.browserName(Browser.CHROME.browserName()), (Object)"org.openqa.selenium.chrome.ChromeDriverService").put(ActiveSessionFactory.containsKey("chromeOptions"), (Object)"org.openqa.selenium.chrome.ChromeDriverService").put(ActiveSessionFactory.browserName(Browser.EDGE.browserName()), (Object)"org.openqa.selenium.edge.ChromiumEdgeDriverService").put(ActiveSessionFactory.containsKey("edgeOptions"), (Object)"org.openqa.selenium.edge.ChromiumEdgeDriverService").put(ActiveSessionFactory.browserName(Browser.FIREFOX.browserName()), (Object)"org.openqa.selenium.firefox.GeckoDriverService").put(ActiveSessionFactory.containsKey(Pattern.compile("^moz:.*")), (Object)"org.openqa.selenium.firefox.GeckoDriverService").put(ActiveSessionFactory.browserName(Browser.IE.browserName()), (Object)"org.openqa.selenium.ie.InternetExplorerDriverService").put(ActiveSessionFactory.containsKey("se:ieOptions"), (Object)"org.openqa.selenium.ie.InternetExplorerDriverService").put(ActiveSessionFactory.browserName(Browser.OPERA.browserName()), (Object)"org.openqa.selenium.opera.OperaDriverService").put(ActiveSessionFactory.browserName(Browser.SAFARI.browserName()), (Object)"org.openqa.selenium.safari.SafariDriverService").put(ActiveSessionFactory.containsKey(Pattern.compile("^safari\\..*")), (Object)"org.openqa.selenium.safari.SafariDriverService").build().entrySet().stream().filter(e -> CLASS_EXISTS.apply((String)e.getValue()) != null).forEach(e -> builder.add((Object)new ServicedSession.Factory(tracer, (Predicate)e.getKey(), (String)e.getValue())));
        this.bind((ImmutableList.Builder<SessionFactory>)builder, "org.openqa.selenium.htmlunit.HtmlUnitDriver", ActiveSessionFactory.browserName(Browser.HTMLUNIT.browserName()), (Capabilities)new ImmutableCapabilities("browserName", (Object)Browser.HTMLUNIT.browserName()));
        this.factories = builder.build();
    }

    public synchronized ActiveSessionFactory bind(Predicate<Capabilities> onThis, SessionFactory useThis) {
        Require.nonNull((String)"Predicate", onThis);
        Require.nonNull((String)"SessionFactory", (Object)useThis);
        LOG.info(String.format("Binding %s to respond to %s", useThis, onThis));
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)useThis);
        builder.addAll(this.factories);
        this.factories = builder.build();
        return this;
    }

    @VisibleForTesting
    protected Iterable<DriverProvider> loadDriverProviders() {
        return () -> ServiceLoader.load(DriverProvider.class).iterator();
    }

    private void bind(ImmutableList.Builder<SessionFactory> builder, String className, Predicate<Capabilities> predicate, Capabilities capabilities) {
        try {
            Class<?> clazz = CLASS_EXISTS.apply(className);
            if (clazz == null) {
                return;
            }
            Class<WebDriver> driverClass = clazz.asSubclass(WebDriver.class);
            builder.add((Object)new InMemorySession.Factory(new DefaultDriverProvider(capabilities, driverClass)));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private static Predicate<Capabilities> browserName(String browserName) {
        Require.nonNull((String)"Browser name", (Object)browserName);
        return toCompare -> browserName.equals(toCompare.getBrowserName());
    }

    private static Predicate<Capabilities> containsKey(String keyName) {
        Require.nonNull((String)"Key name", (Object)keyName);
        return toCompare -> toCompare.getCapability(keyName) != null;
    }

    private static Predicate<Capabilities> containsKey(Pattern pattern) {
        return toCompare -> toCompare.asMap().keySet().stream().anyMatch(pattern.asPredicate());
    }

    public boolean test(Capabilities capabilities) {
        return this.factories.stream().map(factory -> factory.test((Object)capabilities)).reduce(Boolean::logicalOr).orElse(false);
    }

    public Optional<ActiveSession> apply(CreateSessionRequest sessionRequest) {
        LOG.finest("Capabilities are: " + new Json().toJson((Object)sessionRequest.getDesiredCapabilities()));
        return this.factories.stream().filter(factory -> factory.test((Object)sessionRequest.getDesiredCapabilities())).peek(factory -> LOG.finest(String.format("Matched factory %s", factory))).map(factory -> (Optional)factory.apply((Object)sessionRequest)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }
}

