/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.session.ActiveSession;
import org.openqa.selenium.grid.session.SessionFactory;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.DriverProvider;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.JsonHttpCommandHandler;
import org.openqa.selenium.remote.server.KnownElements;
import org.openqa.selenium.remote.server.Session;

class InMemorySession
implements ActiveSession {
    private static final Logger LOG = Logger.getLogger(InMemorySession.class.getName());
    private final WebDriver driver;
    private final Map<String, Object> capabilities;
    private final SessionId id;
    private final Dialect downstream;
    private final TemporaryFilesystem filesystem;
    private final JsonHttpCommandHandler handler;

    private InMemorySession(WebDriver driver, Capabilities capabilities, Dialect downstream) {
        this.driver = (WebDriver)Require.nonNull((String)"Driver", (Object)driver);
        Capabilities caps = driver instanceof HasCapabilities ? ((HasCapabilities)driver).getCapabilities() : capabilities;
        this.capabilities = (Map)caps.asMap().entrySet().stream().filter(e -> e.getValue() != null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        this.id = new SessionId(UUID.randomUUID().toString());
        this.downstream = (Dialect)Require.nonNull((String)"Downstream dialect", (Object)downstream);
        File tempRoot = new File(StandardSystemProperty.JAVA_IO_TMPDIR.value(), this.id.toString());
        Require.stateCondition((boolean)tempRoot.mkdirs(), (String)"Could not create directory %s", (Object[])new Object[]{tempRoot});
        this.filesystem = TemporaryFilesystem.getTmpFsBasedOn((File)tempRoot);
        this.handler = new JsonHttpCommandHandler(new PretendDriverSessions(), LOG);
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        HttpResponse res = new HttpResponse();
        this.handler.handleRequest(req, res);
        return res;
    }

    public SessionId getId() {
        return this.id;
    }

    public Dialect getUpstreamDialect() {
        return Dialect.OSS;
    }

    public Dialect getDownstreamDialect() {
        return this.downstream;
    }

    public Map<String, Object> getCapabilities() {
        return this.capabilities;
    }

    public TemporaryFilesystem getFileSystem() {
        return this.filesystem;
    }

    public WebDriver getWrappedDriver() {
        return this.driver;
    }

    public void stop() {
        this.driver.quit();
    }

    private class ActualSession
    implements Session {
        private final KnownElements knownElements = new KnownElements();
        private volatile String screenshot;

        private ActualSession() {
        }

        @Override
        public void close() {
            InMemorySession.this.driver.quit();
        }

        @Override
        public WebDriver getDriver() {
            return InMemorySession.this.driver;
        }

        @Override
        public KnownElements getKnownElements() {
            return this.knownElements;
        }

        @Override
        public Map<String, Object> getCapabilities() {
            return InMemorySession.this.capabilities;
        }

        @Override
        public void attachScreenshot(String base64EncodedImage) {
            this.screenshot = base64EncodedImage;
        }

        @Override
        public String getAndClearScreenshot() {
            String toReturn = this.screenshot;
            this.screenshot = null;
            return toReturn;
        }

        @Override
        public SessionId getSessionId() {
            return InMemorySession.this.getId();
        }

        @Override
        public TemporaryFilesystem getTemporaryFileSystem() {
            return InMemorySession.this.getFileSystem();
        }
    }

    private class PretendDriverSessions
    implements DriverSessions {
        private final Session session;

        private PretendDriverSessions() {
            this.session = new ActualSession();
        }

        @Override
        public Session get(SessionId sessionId) {
            return InMemorySession.this.getId().equals((Object)sessionId) ? this.session : null;
        }

        @Override
        public Set<SessionId> getSessions() {
            return ImmutableSet.of((Object)InMemorySession.this.getId());
        }
    }

    public static class Factory
    implements SessionFactory {
        private final DriverProvider provider;

        public Factory(DriverProvider provider) {
            this.provider = provider;
        }

        public boolean test(Capabilities capabilities) {
            return this.provider.canCreateDriverInstanceFor(capabilities);
        }

        public Optional<ActiveSession> apply(CreateSessionRequest sessionRequest) {
            Require.nonNull((String)"Session creation request", (Object)sessionRequest);
            try {
                if (!this.provider.canCreateDriverInstanceFor(sessionRequest.getDesiredCapabilities())) {
                    return Optional.empty();
                }
                WebDriver driver = this.provider.newInstance(sessionRequest.getDesiredCapabilities());
                Set downstreamDialects = sessionRequest.getDownstreamDialects();
                Dialect downstream = downstreamDialects.contains(Dialect.OSS) || downstreamDialects.isEmpty() ? Dialect.OSS : (Dialect)downstreamDialects.iterator().next();
                return Optional.of(new InMemorySession(driver, sessionRequest.getDesiredCapabilities(), downstream));
            }
            catch (IllegalStateException e) {
                return Optional.empty();
            }
        }

        public String toString() {
            return this.getClass() + " (provider: " + this.provider + ")";
        }
    }
}

