/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class NodeStatus {
    private final NodeId nodeId;
    private final URI externalUri;
    private final int maxSessionCount;
    private final Set<Slot> slots;
    private final Availability availability;
    private final String version;
    private final Map<String, String> osInfo;

    public NodeStatus(NodeId nodeId, URI externalUri, int maxSessionCount, Set<Slot> slots, Availability availability, String version, Map<String, String> osInfo) {
        this.nodeId = (NodeId)Require.nonNull((String)"Node id", (Object)nodeId);
        this.externalUri = (URI)Require.nonNull((String)"URI", (Object)externalUri);
        this.maxSessionCount = Require.positive((String)"Max session count", (Integer)maxSessionCount, (String)"Make sure that a driver is available on $PATH");
        this.slots = Collections.unmodifiableSet(new HashSet((Collection)Require.nonNull((String)"Slots", slots)));
        this.availability = (Availability)((Object)Require.nonNull((String)"Availability", (Object)((Object)availability)));
        this.version = (String)Require.nonNull((String)"Grid Node version", (Object)version);
        this.osInfo = (Map)Require.nonNull((String)"Node host OS info", osInfo);
    }

    public static NodeStatus fromJson(JsonInput input) {
        NodeId nodeId = null;
        URI uri = null;
        int maxSessions = 0;
        Set slots = null;
        Availability availability = null;
        String version = null;
        Map osInfo = null;
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "availability": {
                    availability = (Availability)((Object)input.read(Availability.class));
                    continue block18;
                }
                case "id": {
                    nodeId = (NodeId)input.read(NodeId.class);
                    continue block18;
                }
                case "maxSessions": {
                    maxSessions = (Integer)input.read(Integer.class);
                    continue block18;
                }
                case "slots": {
                    slots = (Set)input.read(new TypeToken<Set<Slot>>(){}.getType());
                    continue block18;
                }
                case "uri": {
                    uri = (URI)input.read(URI.class);
                    continue block18;
                }
                case "version": {
                    version = (String)input.read(String.class);
                    continue block18;
                }
                case "osInfo": {
                    osInfo = (Map)input.read(Map.class);
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new NodeStatus(nodeId, uri, maxSessions, slots, availability, version, osInfo);
    }

    public boolean hasCapability(Capabilities caps) {
        return this.slots.stream().anyMatch(slot -> slot.isSupporting(caps));
    }

    public boolean hasCapacity() {
        return this.slots.stream().anyMatch(slot -> !slot.getSession().isPresent());
    }

    public boolean hasCapacity(Capabilities caps) {
        return this.slots.stream().anyMatch(slot -> !slot.getSession().isPresent() && slot.isSupporting(caps));
    }

    public NodeId getId() {
        return this.nodeId;
    }

    public URI getUri() {
        return this.externalUri;
    }

    public int getMaxSessionCount() {
        return this.maxSessionCount;
    }

    public Set<Slot> getSlots() {
        return this.slots;
    }

    public Availability getAvailability() {
        return this.availability;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getOsInfo() {
        return this.osInfo;
    }

    public float getLoad() {
        float inUse = this.slots.parallelStream().filter(slot -> slot.getSession().isPresent()).count();
        return inUse / (float)this.maxSessionCount * 100.0f;
    }

    public long getLastSessionCreated() {
        return this.slots.parallelStream().map(Slot::getLastStarted).mapToLong(Instant::toEpochMilli).max().orElse(0L);
    }

    public boolean equals(Object o) {
        if (!(o instanceof NodeStatus)) {
            return false;
        }
        NodeStatus that = (NodeStatus)o;
        return Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.externalUri, that.externalUri) && this.maxSessionCount == that.maxSessionCount && Objects.equals(this.slots, that.slots) && Objects.equals((Object)this.availability, (Object)that.availability) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.externalUri, this.maxSessionCount, this.slots, this.version);
    }

    private Map<String, Object> toJson() {
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        toReturn.put("id", this.nodeId);
        toReturn.put("uri", this.externalUri);
        toReturn.put("maxSessions", this.maxSessionCount);
        toReturn.put("slots", this.slots);
        toReturn.put("availability", (Object)this.availability);
        toReturn.put("version", this.version);
        toReturn.put("osInfo", this.osInfo);
        return Collections.unmodifiableMap(toReturn);
    }
}

