/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.commandhandler;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.grid.session.ActiveSession;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.io.Zip;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class UploadFile
implements HttpHandler {
    private final Json json;
    private final ActiveSession session;

    public UploadFile(Json json, ActiveSession session) {
        this.json = (Json)Require.nonNull((String)"Json converter", (Object)json);
        this.session = (ActiveSession)Require.nonNull((String)"Current session", (Object)session);
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        Map args = (Map)this.json.toType(Contents.string((HttpMessage)req), Json.MAP_TYPE);
        String file = (String)args.get("file");
        File tempDir = this.session.getFileSystem().createTempDir("upload", "file");
        try {
            Zip.unzip((String)file, (File)tempDir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        File[] allFiles = tempDir.listFiles();
        Response response = new Response(this.session.getId());
        if (allFiles == null || allFiles.length != 1) {
            response.setStatus(Integer.valueOf(13));
            response.setValue((Object)new WebDriverException("Expected there to be only 1 file. There were: " + (allFiles == null ? 0 : allFiles.length)));
        } else {
            response.setStatus(Integer.valueOf(0));
            response.setValue((Object)allFiles[0].getAbsolutePath());
        }
        HttpResponse resp = new HttpResponse();
        this.session.getDownstreamDialect().getResponseCodec().encode(() -> resp, response);
        return resp;
    }
}

