/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class NodeStatus {
    private final NodeId nodeId;
    private final URI externalUri;
    private final int maxSessionCount;
    private final Set<Slot> slots;
    private final Availability availability;

    public NodeStatus(NodeId nodeId, URI externalUri, int maxSessionCount, Set<Slot> slots, Availability availability) {
        this.nodeId = (NodeId)Require.nonNull((String)"Node id", (Object)nodeId);
        this.externalUri = (URI)Require.nonNull((String)"URI", (Object)externalUri);
        this.maxSessionCount = Require.positive((String)"Max session count", (Integer)maxSessionCount, (String)"Make sure that a driver is available on $PATH");
        this.slots = ImmutableSet.copyOf((Collection)((Collection)Require.nonNull((String)"Slots", slots)));
        this.availability = (Availability)((Object)Require.nonNull((String)"Availability", (Object)((Object)availability)));
        ImmutableSet.Builder sessions = ImmutableSet.builder();
        for (Slot slot : slots) {
            slot.getSession().ifPresent(arg_0 -> ((ImmutableSet.Builder)sessions).add(arg_0));
        }
    }

    public boolean hasCapability(Capabilities caps) {
        return this.slots.stream().anyMatch(slot -> slot.isSupporting(caps));
    }

    public boolean hasCapacity() {
        return this.slots.stream().anyMatch(slot -> slot.getSession().isEmpty());
    }

    public boolean hasCapacity(Capabilities caps) {
        return this.slots.stream().anyMatch(slot -> slot.getSession().isEmpty() && slot.isSupporting(caps));
    }

    public NodeId getId() {
        return this.nodeId;
    }

    public URI getUri() {
        return this.externalUri;
    }

    public int getMaxSessionCount() {
        return this.maxSessionCount;
    }

    public Set<Slot> getSlots() {
        return this.slots;
    }

    public Availability getAvailability() {
        return this.availability;
    }

    public float getLoad() {
        float inUse = this.slots.parallelStream().filter(slot -> slot.getSession().isPresent()).count();
        return inUse / (float)this.maxSessionCount * 100.0f;
    }

    public long getLastSessionCreated() {
        return this.slots.parallelStream().map(Slot::getLastStarted).mapToLong(Instant::toEpochMilli).max().orElse(0L);
    }

    public boolean equals(Object o) {
        if (!(o instanceof NodeStatus)) {
            return false;
        }
        NodeStatus that = (NodeStatus)o;
        return Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.externalUri, that.externalUri) && this.maxSessionCount == that.maxSessionCount && Objects.equals(this.slots, that.slots) && Objects.equals((Object)this.availability, (Object)that.availability);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.externalUri, this.maxSessionCount, this.slots);
    }

    private Map<String, Object> toJson() {
        return new ImmutableMap.Builder().put((Object)"id", (Object)this.nodeId).put((Object)"uri", (Object)this.externalUri).put((Object)"maxSessions", (Object)this.maxSessionCount).put((Object)"slots", this.slots).put((Object)"availability", (Object)this.availability).build();
    }

    public static NodeStatus fromJson(JsonInput input) {
        NodeId nodeId = null;
        URI uri = null;
        int maxSessions = 0;
        Set slots = null;
        Availability availability = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "availability": {
                    availability = (Availability)((Object)input.read(Availability.class));
                    continue block14;
                }
                case "id": {
                    nodeId = (NodeId)input.read(NodeId.class);
                    continue block14;
                }
                case "maxSessions": {
                    maxSessions = (Integer)input.read(Integer.class);
                    continue block14;
                }
                case "slots": {
                    slots = (Set)input.read(new TypeToken<Set<Slot>>(){}.getType());
                    continue block14;
                }
                case "uri": {
                    uri = (URI)input.read(URI.class);
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new NodeStatus(nodeId, uri, maxSessions, slots, availability);
    }
}

