/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.collect.ImmutableSet;
import java.io.UncheckedIOException;
import java.util.logging.Logger;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

public class ReverseProxyHandler
implements HttpHandler {
    private static final Logger LOG = Logger.getLogger(ReverseProxyHandler.class.getName());
    private static final ImmutableSet<String> IGNORED_REQ_HEADERS = ImmutableSet.builder().add((Object)"connection").add((Object)"keep-alive").add((Object)"proxy-authorization").add((Object)"proxy-authenticate").add((Object)"proxy-connection").add((Object)"te").add((Object)"trailer").add((Object)"transfer-encoding").add((Object)"upgrade").build();
    private final Tracer tracer;
    private final HttpClient upstream;

    public ReverseProxyHandler(Tracer tracer, HttpClient httpClient) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.upstream = (HttpClient)Require.nonNull((String)"HTTP client", (Object)httpClient);
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        try (Span span = HttpTracing.newSpanAsChildOf((Tracer)this.tracer, (HttpRequest)req, (String)"reverse_proxy");){
            Tags.HTTP_REQUEST.accept(span, req);
            HttpRequest toUpstream = new HttpRequest(req.getMethod(), req.getUri());
            for (String name : req.getQueryParameterNames()) {
                for (String value : req.getQueryParameters(name)) {
                    toUpstream.addQueryParameter(name, value);
                }
            }
            for (String name : req.getHeaderNames()) {
                if (IGNORED_REQ_HEADERS.contains((Object)name.toLowerCase())) continue;
                for (String value : req.getHeaders(name)) {
                    toUpstream.addHeader(name, value);
                }
            }
            toUpstream.setHeader("Connection", "keep-alive");
            toUpstream.setContent(req.getContent());
            HttpResponse resp = this.upstream.execute(toUpstream);
            span.setAttribute("http.status", (Number)resp.getStatus());
            resp.removeHeader("Date");
            resp.removeHeader("Server");
            IGNORED_REQ_HEADERS.forEach(x$0 -> {
                HttpResponse cfr_ignored_0 = (HttpResponse)resp.removeHeader(x$0);
            });
            HttpResponse httpResponse = resp;
            return httpResponse;
        }
    }
}

