/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.grid.web.Resource;

public class PathResource
implements Resource {
    private final Path base;

    public PathResource(Path base) {
        this.base = Objects.requireNonNull(base).normalize();
    }

    @Override
    public String name() {
        return this.base.getFileName().toString();
    }

    @Override
    public Optional<Resource> get(String path) {
        Path normalized;
        if (path.startsWith("/")) {
            String string = path = path.length() == 1 ? "" : path.substring(1);
        }
        if (!(normalized = this.base.resolve(path).normalize()).startsWith(this.base)) {
            throw new RuntimeException("Attempt to navigate away from the parent directory");
        }
        if (Files.exists(normalized, new LinkOption[0])) {
            return Optional.of(new PathResource(normalized));
        }
        return Optional.empty();
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.base, new LinkOption[0]);
    }

    @Override
    public Set<Resource> list() {
        try {
            return (Set)Files.list(this.base).map(PathResource::new).collect(ImmutableSet.toImmutableSet());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Optional<byte[]> read() {
        if (!Files.exists(this.base, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            return Optional.of(Files.readAllBytes(this.base));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

