/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.session.remote;

import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import io.opentracing.Tracer;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.grid.session.ActiveSession;
import org.openqa.selenium.grid.session.SessionFactory;
import org.openqa.selenium.grid.session.remote.ActiveSessionCommandExecutor;
import org.openqa.selenium.grid.web.ProtocolConverter;
import org.openqa.selenium.grid.web.ReverseProxyHandler;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public abstract class RemoteSession
implements ActiveSession {
    protected static Logger log = Logger.getLogger(ActiveSession.class.getName());
    private final SessionId id;
    private final Dialect downstream;
    private final Dialect upstream;
    private final HttpHandler codec;
    private final Map<String, Object> capabilities;
    private final TemporaryFilesystem filesystem;
    private final WebDriver driver;

    protected RemoteSession(Dialect downstream, Dialect upstream, HttpHandler codec, SessionId id, Map<String, Object> capabilities) {
        this.downstream = Objects.requireNonNull(downstream);
        this.upstream = Objects.requireNonNull(upstream);
        this.codec = Objects.requireNonNull(codec);
        this.id = Objects.requireNonNull(id);
        this.capabilities = Objects.requireNonNull(capabilities);
        File tempRoot = new File(StandardSystemProperty.JAVA_IO_TMPDIR.value(), id.toString());
        Preconditions.checkState((boolean)tempRoot.mkdirs());
        this.filesystem = TemporaryFilesystem.getTmpFsBasedOn((File)tempRoot);
        ActiveSessionCommandExecutor executor = new ActiveSessionCommandExecutor(this);
        this.driver = new Augmenter().augment((WebDriver)new RemoteWebDriver((CommandExecutor)executor, (Capabilities)new ImmutableCapabilities(this.getCapabilities())));
    }

    @Override
    public SessionId getId() {
        return this.id;
    }

    @Override
    public Dialect getUpstreamDialect() {
        return this.upstream;
    }

    @Override
    public Dialect getDownstreamDialect() {
        return this.downstream;
    }

    @Override
    public Map<String, Object> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public TemporaryFilesystem getFileSystem() {
        return this.filesystem;
    }

    public WebDriver getWrappedDriver() {
        return this.driver;
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        return this.codec.execute(req);
    }

    public static abstract class Factory<X>
    implements SessionFactory {
        protected Optional<ActiveSession> performHandshake(Tracer tracer, X additionalData, URL url, Set<Dialect> downstreamDialects, Capabilities capabilities) {
            try {
                Dialect downstream;
                Object codec;
                HttpClient client = HttpClient.Factory.createDefault().createClient(url);
                Command command = new Command(null, DriverCommand.NEW_SESSION((Capabilities)capabilities));
                ProtocolHandshake.Result result = new ProtocolHandshake().createSession(client, command);
                Dialect upstream = result.getDialect();
                if (downstreamDialects.contains(result.getDialect())) {
                    codec = new ReverseProxyHandler(tracer, client);
                    downstream = upstream;
                } else {
                    downstream = downstreamDialects.isEmpty() ? Dialect.OSS : downstreamDialects.iterator().next();
                    codec = new ProtocolConverter(tracer, client, downstream, upstream);
                }
                Response response = result.createResponse();
                Optional<ActiveSession> activeSession = Optional.of(this.newActiveSession(additionalData, downstream, upstream, (HttpHandler)codec, new SessionId(response.getSessionId()), (Map)response.getValue()));
                activeSession.ifPresent(session -> log.info("Started new session " + session));
                return activeSession;
            }
            catch (IOException | IllegalStateException | NullPointerException e) {
                log.log(Level.WARNING, e.getMessage(), e);
                return Optional.empty();
            }
        }

        protected abstract ActiveSession newActiveSession(X var1, Dialect var2, Dialect var3, HttpHandler var4, SessionId var5, Map<String, Object> var6);
    }
}

