/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.webdriven.commands;

import com.thoughtworks.selenium.Wait;
import com.thoughtworks.selenium.webdriven.ScriptMutator;
import com.thoughtworks.selenium.webdriven.SeleneseCommand;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class WaitForCondition
extends SeleneseCommand<Void> {
    private final ScriptMutator mutator;
    private final Runnable sleepUntil;

    public WaitForCondition(ScriptMutator mutator, Runnable sleepUntil) {
        this.mutator = mutator;
        this.sleepUntil = sleepUntil;
    }

    @Override
    protected Void handleSeleneseCommand(final WebDriver driver, String script, String timeout) {
        StringBuilder builder = new StringBuilder();
        this.mutator.mutate(script, builder);
        final String modified = builder.toString();
        this.sleepUntil.run();
        new Wait(){

            @Override
            public boolean until() {
                Object result = ((JavascriptExecutor)driver).executeScript(modified, new Object[0]);
                if (result == null) {
                    return false;
                }
                if (result instanceof String) {
                    return !"".equals(result);
                }
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                return true;
            }
        }.wait("Failed to resolve " + script, Long.valueOf(timeout));
        return null;
    }
}

