/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.server.htmlrunner.CoreTestCase;
import org.openqa.selenium.server.htmlrunner.HTMLTestResults;

public class Results {
    private final String suiteSource;
    private final List<String> allTables = new LinkedList<String>();
    private final List<Boolean> allResults = new LinkedList<Boolean>();
    private final StringBuilder log = new StringBuilder();
    private final long start = System.currentTimeMillis();
    private boolean succeeded = true;
    private long numberOfPasses;
    private long commandPasses;
    private long commandFailures;
    private long commandErrors;

    public Results(String suiteSource) {
        this.suiteSource = suiteSource;
    }

    public boolean isSuccessful() {
        return this.succeeded;
    }

    public void addTest(String rawSource, List<CoreTestCase.StepResult> stepResults) {
        boolean passed = true;
        for (CoreTestCase.StepResult stepResult : stepResults) {
            passed &= stepResult.isSuccessful();
            if (stepResult.isSuccessful()) {
                ++this.commandPasses;
            } else if (stepResult.isError()) {
                ++this.commandErrors;
            } else {
                ++this.commandFailures;
            }
            this.log.append(stepResult.getStepLog()).append("\n");
        }
        if (passed) {
            ++this.numberOfPasses;
        }
        this.succeeded &= passed;
        this.allTables.add(this.massage(rawSource, "insert-core-result", stepResults, input -> input.getRenderableClass()));
        this.allResults.add(passed);
    }

    private <X> String massage(String rawSource, String toSubstitute, List<X> toConvert, Function<X, String> transform) {
        ElementCallback callback;
        StringReader stringReader = new StringReader(rawSource);
        HTMLEditorKit htmlKit = new HTMLEditorKit();
        HTMLDocument doc = (HTMLDocument)htmlKit.createDefaultDocument();
        HTMLEditorKit.Parser parser = doc.getParser();
        doc.setAsynchronousLoadPriority(-1);
        try {
            callback = new ElementCallback(toSubstitute, toConvert.stream().map(transform).iterator());
            parser.parse(stringReader, callback, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse test table");
        }
        StringBuilder sb = new StringBuilder();
        int previousPosition = rawSource.length();
        for (int i = callback.tagPositions.size() - 1; i >= 0; --i) {
            int pos = (Integer)callback.tagPositions.get(i);
            String toReplace = (String)callback.originals.get(i);
            String substitution = (String)callback.substitutions.get(i);
            String snippet = rawSource.substring(pos, previousPosition).replace('\\', '/');
            String replaceSnippet = snippet.replaceFirst("\\Q" + toReplace + "\\E", substitution);
            sb.insert(0, replaceSnippet);
            previousPosition = pos;
        }
        String snippet = rawSource.substring(0, previousPosition);
        sb.insert(0, snippet);
        return sb.toString();
    }

    public HTMLTestResults toSuiteResult() {
        BuildInfo buildInfo = new BuildInfo();
        return new HTMLTestResults(buildInfo.getReleaseLabel(), buildInfo.getBuildRevision(), this.isSuccessful() ? "PASS" : "FAIL", String.valueOf(System.currentTimeMillis() - this.start), String.valueOf(this.allTables.size()), String.valueOf(this.numberOfPasses), String.valueOf((long)this.allTables.size() - this.numberOfPasses), String.valueOf(this.commandPasses), String.valueOf(this.commandFailures), String.valueOf(this.commandErrors), this.massage(this.suiteSource, "insert-test-result", this.allResults, input -> input != false ? "status_passed" : "status_failed"), this.allTables, this.log.toString());
    }

    private static class ElementCallback
    extends HTMLEditorKit.ParserCallback {
        private final String toSubstitute;
        private final List<Integer> tagPositions = new LinkedList<Integer>();
        private final List<String> originals = new LinkedList<String>();
        private final List<String> substitutions = new LinkedList<String>();
        private final Iterator<String> allResults;

        public ElementCallback(String toSubstitute, Iterator<String> allResults) {
            this.toSubstitute = toSubstitute;
            this.allResults = allResults;
        }

        @Override
        public void handleStartTag(HTML.Tag tag, MutableAttributeSet attrs, int pos) {
            String classes;
            Object rawAttr;
            if (this.allResults.hasNext() && HTML.Tag.TR.equals(tag) && (rawAttr = attrs.getAttribute(HTML.Attribute.CLASS)) != null && (classes = String.valueOf(rawAttr)).contains(this.toSubstitute)) {
                String result = this.allResults.next();
                this.originals.add(classes);
                this.substitutions.add(classes.replace(this.toSubstitute, result));
                this.tagPositions.add(pos);
            }
        }
    }
}

