/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.openqa.selenium.grid.web.CombinedHandler;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.WebSocket;

public class RoutableHttpClientFactory
implements HttpClient.Factory {
    private final URL self;
    private final CombinedHandler handler;
    private final HttpClient.Factory delegate;

    public RoutableHttpClientFactory(URL self, CombinedHandler handler, HttpClient.Factory delegate) {
        this.self = Objects.requireNonNull(self);
        this.handler = Objects.requireNonNull(handler);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public HttpClient.Builder builder() {
        return new HttpClient.Builder(){

            public HttpClient createClient(URL url) {
                if (RoutableHttpClientFactory.this.self.getProtocol().equals(url.getProtocol()) && RoutableHttpClientFactory.this.self.getHost().equals(url.getHost()) && RoutableHttpClientFactory.this.self.getPort() == url.getPort()) {
                    return new HttpClient(){

                        public HttpResponse execute(HttpRequest request) throws IOException {
                            HttpResponse response = new HttpResponse();
                            if (!RoutableHttpClientFactory.this.handler.test(request)) {
                                response.setStatus(404);
                                response.setContent(("Unable to route " + request).getBytes(StandardCharsets.UTF_8));
                                return response;
                            }
                            RoutableHttpClientFactory.this.handler.execute(request, response);
                            return response;
                        }

                        public WebSocket openSocket(HttpRequest request, WebSocket.Listener listener) {
                            throw new UnsupportedOperationException("openSocket");
                        }
                    };
                }
                return RoutableHttpClientFactory.this.delegate.createClient(url);
            }
        };
    }

    public void cleanupIdleClients() {
        this.delegate.cleanupIdleClients();
    }
}

