/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.webdriven.commands;

import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.webdriven.SeleneseCommand;
import com.thoughtworks.selenium.webdriven.commands.GetEval;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.WebDriver;

public class OpenWindow
extends SeleneseCommand<Void> {
    private final URL baseUrl;
    private final GetEval opener;

    public OpenWindow(String baseUrl, GetEval opener) {
        try {
            this.baseUrl = new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new SeleniumException(e.getMessage(), e);
        }
        this.opener = opener;
    }

    @Override
    protected Void handleSeleneseCommand(WebDriver driver, String url, String windowID) {
        try {
            String urlToOpen = url.contains("://") ? url : new URL(this.baseUrl, url).toString();
            String[] args = new String[]{String.format("window.open('%s', '%s'); null;", urlToOpen, windowID)};
            this.opener.apply(driver, args);
        }
        catch (MalformedURLException e) {
            throw new SeleniumException(e.getMessage(), e);
        }
        return null;
    }
}

