/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.base.Splitter;
import com.google.common.net.MediaType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.openqa.selenium.logging.LoggingHandler;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.ActiveSession;
import org.openqa.selenium.remote.server.ActiveSessions;
import org.openqa.selenium.remote.server.AllHandlers;
import org.openqa.selenium.remote.server.CommandHandler;
import org.openqa.selenium.remote.server.DefaultPipeline;
import org.openqa.selenium.remote.server.InputStreamWrappingServletInputStream;
import org.openqa.selenium.remote.server.NewSessionPipeline;
import org.openqa.selenium.remote.server.ServletRequestWrappingHttpRequest;
import org.openqa.selenium.remote.server.ServletResponseWrappingHttpResponse;
import org.openqa.selenium.remote.server.StaticResourceHandler;
import org.openqa.selenium.remote.server.commandhandler.ExceptionHandler;
import org.openqa.selenium.remote.server.log.LoggingManager;
import org.openqa.selenium.remote.server.log.PerSessionLogHandler;
import org.openqa.selenium.remote.server.xdrpc.CrossDomainRpc;
import org.openqa.selenium.remote.server.xdrpc.CrossDomainRpcLoader;

public class WebDriverServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(WebDriverServlet.class.getName());
    public static final String ACTIVE_SESSIONS_KEY = WebDriverServlet.class.getName() + ".sessions";
    public static final String NEW_SESSION_PIPELINE_KEY = WebDriverServlet.class.getName() + ".pipeline";
    private static final String CROSS_DOMAIN_RPC_PATH = "/xdrpc";
    private final StaticResourceHandler staticResourceHandler = new StaticResourceHandler();
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private ActiveSessions allSessions;
    private AllHandlers handlers;

    public void init() throws ServletException {
        NewSessionPipeline pipeline;
        this.configureLogging();
        this.log("Initialising WebDriverServlet");
        String value = this.getInitParameter("webdriver.server.session.timeout");
        long inactiveSessionTimeout = value != null ? TimeUnit.SECONDS.toMillis(Long.parseLong(value)) : Long.MAX_VALUE;
        this.allSessions = (ActiveSessions)this.getServletContext().getAttribute(ACTIVE_SESSIONS_KEY);
        if (this.allSessions == null) {
            this.allSessions = new ActiveSessions(inactiveSessionTimeout, TimeUnit.MILLISECONDS);
            this.getServletContext().setAttribute(ACTIVE_SESSIONS_KEY, (Object)this.allSessions);
        }
        if ((pipeline = (NewSessionPipeline)this.getServletContext().getAttribute(NEW_SESSION_PIPELINE_KEY)) == null) {
            pipeline = DefaultPipeline.createPipelineWithDefaultFallbacks().create();
            this.getServletContext().setAttribute(NEW_SESSION_PIPELINE_KEY, (Object)pipeline);
        }
        this.handlers = new AllHandlers(pipeline, this.allSessions);
    }

    private synchronized Logger configureLogging() {
        Logger logger = Logger.getGlobal();
        logger.addHandler((Handler)LoggingHandler.getInstance());
        Logger rootLogger = Logger.getLogger("");
        boolean sessionLoggerAttached = false;
        for (Handler handler : rootLogger.getHandlers()) {
            sessionLoggerAttached |= handler instanceof PerSessionLogHandler;
        }
        if (!sessionLoggerAttached) {
            rootLogger.addHandler(LoggingManager.perSessionLogHandler());
        }
        return logger;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request.getHeader("Origin") != null) {
            this.setAccessControlHeaders(response);
        }
        response.setHeader("Expires", "Thu, 01 Jan 1970 00:00:00 GMT");
        response.setHeader("Cache-Control", "no-cache");
        super.service(request, response);
    }

    private void setAccessControlHeaders(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "DELETE,GET,HEAD,POST");
        response.setHeader("Access-Control-Allow-Headers", "Accept,Content-Type");
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getPathInfo() == null || "/".equals(req.getPathInfo())) {
            this.staticResourceHandler.redirectToHub(req, resp);
        } else if (this.staticResourceHandler.isStaticResourceRequest(req)) {
            this.staticResourceHandler.service(req, resp);
        } else {
            this.handle(req, resp);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (CROSS_DOMAIN_RPC_PATH.equalsIgnoreCase(req.getPathInfo())) {
            this.handleCrossDomainRpc(req, resp);
        } else {
            this.handle(req, resp);
        }
    }

    private void handleCrossDomainRpc(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        CrossDomainRpc rpc;
        try {
            rpc = new CrossDomainRpcLoader().loadRpc(servletRequest);
        }
        catch (IllegalArgumentException e) {
            servletResponse.setStatus(400);
            servletResponse.getOutputStream().println(e.getMessage());
            servletResponse.getOutputStream().flush();
            return;
        }
        servletRequest.setAttribute("Content-Type", (Object)MediaType.JSON_UTF_8.toString());
        HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(servletRequest){

            public String getMethod() {
                return rpc.getMethod();
            }

            public String getPathInfo() {
                return rpc.getPath();
            }

            public ServletInputStream getInputStream() throws IOException {
                return new InputStreamWrappingServletInputStream(new ByteArrayInputStream(rpc.getContent()));
            }
        };
        this.handle((HttpServletRequest)wrapper, servletResponse);
    }

    private void handle(HttpServletRequest req, HttpServletResponse resp) {
        CommandHandler handler = this.handlers.match(req);
        LOG.info("Found handler: " + handler);
        boolean invalidateSession = handler instanceof ActiveSession && "DELETE".equalsIgnoreCase(req.getMethod()) && req.getPathInfo().equals("/session/" + ((ActiveSession)handler).getId());
        Future<?> execution = this.executor.submit(() -> {
            PerSessionLogHandler sessionLogHandler = LoggingManager.perSessionLogHandler();
            sessionLogHandler.clearThreadTempLogs();
            try {
                if (handler instanceof ActiveSession) {
                    sessionLogHandler.attachToCurrentThread(((ActiveSession)handler).getId());
                    ActiveSession session = (ActiveSession)handler;
                    Thread.currentThread().setName(String.format("Handler thread for session %s (%s)", session.getId(), session.getCapabilities().get("browserName")));
                } else {
                    List fragments = Splitter.on((char)'/').limit(4).splitToList((CharSequence)req.getPathInfo());
                    if (fragments.size() > 2 && "session".equals(fragments.get(1))) {
                        sessionLogHandler.attachToCurrentThread(new SessionId((String)fragments.get(2)));
                    }
                    Thread.currentThread().setName(req.getPathInfo());
                }
                LOG.info(String.format("%s: Executing %s on %s (handler: %s)", Thread.currentThread().getName(), req.getMethod(), req.getPathInfo(), handler.getClass().getSimpleName()));
                handler.execute(new ServletRequestWrappingHttpRequest(req), new ServletResponseWrappingHttpResponse(resp));
            }
            catch (IOException e) {
                resp.reset();
                throw new RuntimeException(e);
            }
            finally {
                Thread.currentThread().setName("Selenium WebDriver Servlet - Quiescent Thread");
                sessionLogHandler.detachFromCurrentThread();
            }
        });
        try {
            execution.get(10L, TimeUnit.MINUTES);
        }
        catch (ExecutionException e) {
            resp.reset();
            new ExceptionHandler(e).execute(new ServletRequestWrappingHttpRequest(req), new ServletResponseWrappingHttpResponse(resp));
        }
        catch (InterruptedException e) {
            this.log("Unexpectedly interrupted: " + e.getMessage(), e);
            invalidateSession = true;
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
            invalidateSession = true;
        }
        if (invalidateSession && handler instanceof ActiveSession) {
            this.allSessions.invalidate(((ActiveSession)handler).getId());
        }
    }
}

