/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;

class InputStreamWrappingServletInputStream
extends ServletInputStream {
    private final InputStream delegate;
    private int lastRead;

    public InputStreamWrappingServletInputStream(InputStream delegate) {
        this.delegate = (InputStream)Preconditions.checkNotNull((Object)delegate);
    }

    public int available() throws IOException {
        return this.delegate.available();
    }

    public void close() throws IOException {
        this.delegate.close();
        this.lastRead = -1;
    }

    public boolean isFinished() {
        return this.lastRead != -1;
    }

    public boolean isReady() {
        return !this.isFinished();
    }

    public void setReadListener(ReadListener readListener) {
        throw new UnsupportedOperationException("setReadListener");
    }

    public int read() throws IOException {
        this.lastRead = this.delegate.read();
        return this.lastRead;
    }

    public boolean markSupported() {
        return false;
    }
}

