/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.ActiveSession;
import org.openqa.selenium.remote.server.ActiveSessionFactory;
import org.openqa.selenium.remote.server.ActiveSessions;
import org.openqa.selenium.remote.server.CommandHandler;
import org.openqa.selenium.remote.server.NewSessionPayload;
import org.openqa.selenium.remote.server.log.LoggingManager;

class BeginSession
implements CommandHandler {
    private final ActiveSessionFactory sessionFactory;
    private final ActiveSessions allSessions;

    public BeginSession(ActiveSessions allSessions) {
        this.allSessions = allSessions;
        this.sessionFactory = new ActiveSessionFactory();
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        ImmutableMap toConvert;
        ActiveSession session;
        String lengthString = req.getHeader("Content-Length");
        long contentLength = Long.MAX_VALUE;
        if (lengthString != null) {
            try {
                contentLength = Long.parseLong(lengthString);
            }
            catch (NumberFormatException e) {
                contentLength = Long.MAX_VALUE;
            }
        }
        try (InputStreamReader reader = new InputStreamReader(req.consumeContentStream(), req.getContentEncoding());
             NewSessionPayload payload = new NewSessionPayload(contentLength, reader);){
            session = this.sessionFactory.createSession(payload);
            this.allSessions.put(session);
        }
        LoggingPreferences loggingPrefs = new LoggingPreferences();
        loggingPrefs.enable("server", Level.INFO);
        Object raw = session.getCapabilities().get("loggingPrefs");
        if (raw instanceof LoggingPreferences) {
            loggingPrefs.addPreferences((LoggingPreferences)raw);
        }
        LoggingManager.perSessionLogHandler().configureLogging(loggingPrefs);
        LoggingManager.perSessionLogHandler().attachToCurrentThread(session.getId());
        switch (session.getDownstreamDialect()) {
            case OSS: {
                toConvert = ImmutableMap.of((Object)"status", (Object)0, (Object)"sessionId", (Object)session.getId().toString(), (Object)"value", session.getCapabilities());
                break;
            }
            case W3C: {
                toConvert = ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"sessionId", (Object)session.getId().toString(), (Object)"capabilities", session.getCapabilities()));
                break;
            }
            default: {
                throw new SessionNotCreatedException("Unrecognized downstream dialect: " + session.getDownstreamDialect());
            }
        }
        byte[] payload = new BeanToJsonConverter().convert((Object)toConvert).getBytes(StandardCharsets.UTF_8);
        resp.setStatus(200);
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        resp.setHeader("Content-Length", String.valueOf(payload.length));
        resp.setContent(payload);
    }
}

