/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.JsonHttpCommandCodec;
import org.openqa.selenium.remote.http.JsonHttpResponseCodec;
import org.openqa.selenium.remote.http.W3CHttpCommandCodec;
import org.openqa.selenium.remote.http.W3CHttpResponseCodec;
import org.openqa.selenium.remote.internal.ApacheHttpClient;
import org.openqa.selenium.remote.server.ActiveSession;
import org.openqa.selenium.remote.server.NewSessionPayload;
import org.openqa.selenium.remote.server.Passthrough;
import org.openqa.selenium.remote.server.ProtocolConverter;
import org.openqa.selenium.remote.server.SessionCodec;
import org.openqa.selenium.remote.server.SessionFactory;
import org.openqa.selenium.remote.service.DriverService;

class ServicedSession
implements ActiveSession {
    private static final Logger LOG = Logger.getLogger(ActiveSession.class.getName());
    private final DriverService service;
    private final SessionId id;
    private Dialect downstream;
    private Dialect upstream;
    private final SessionCodec codec;
    private final Map<String, Object> capabilities;

    public ServicedSession(DriverService service, Dialect downstream, Dialect upstream, SessionCodec codec, SessionId id, Map<String, Object> capabilities) {
        this.service = service;
        this.downstream = downstream;
        this.upstream = upstream;
        this.codec = codec;
        this.id = id;
        this.capabilities = capabilities;
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        this.codec.handle(req, resp);
    }

    @Override
    public SessionId getId() {
        return this.id;
    }

    @Override
    public Dialect getUpstreamDialect() {
        return this.upstream;
    }

    @Override
    public Dialect getDownstreamDialect() {
        return this.downstream;
    }

    @Override
    public Map<String, Object> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public void stop() {
        try {
            HttpRequest request = new HttpRequest(HttpMethod.DELETE, "/session/" + this.getId());
            HttpResponse ignored = new HttpResponse();
            this.execute(request, ignored);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.service.stop();
    }

    public static class Factory
    implements SessionFactory {
        private final Supplier<? extends DriverService> createService;
        private final String serviceClassName;

        public Factory(String serviceClassName) {
            this.serviceClassName = serviceClassName;
            try {
                Class<DriverService> driverClazz = Class.forName(serviceClassName).asSubclass(DriverService.class);
                Method serviceMethod = driverClazz.getMethod("createDefaultService", new Class[0]);
                serviceMethod.setAccessible(true);
                this.createService = () -> {
                    try {
                        return (DriverService)serviceMethod.invoke(null, new Object[0]);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new SessionNotCreatedException("Unable to create new service: " + driverClazz.getSimpleName(), (Throwable)e);
                    }
                };
            }
            catch (ReflectiveOperationException e) {
                throw new SessionNotCreatedException("Cannot find service factory method", (Throwable)e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ActiveSession apply(NewSessionPayload payload) {
            DriverService service = this.createService.get();
            try (InputStream in = payload.getPayload().get();){
                Dialect downstream;
                SessionCodec codec;
                service.start();
                PortProber.waitForPortUp((int)service.getUrl().getPort(), (int)30, (TimeUnit)TimeUnit.SECONDS);
                URL url = service.getUrl();
                HttpClient client = new ApacheHttpClient.Factory().createClient(url);
                ProtocolHandshake.Result result = (ProtocolHandshake.Result)new ProtocolHandshake().createSession(client, in, payload.getPayloadSize()).orElseThrow(() -> new SessionNotCreatedException("Unable to create session"));
                Dialect upstream = result.getDialect();
                if (payload.getDownstreamDialects().contains((Object)result.getDialect())) {
                    codec = new Passthrough(url);
                    downstream = upstream;
                } else {
                    downstream = (Dialect)payload.getDownstreamDialects().iterator().next();
                    codec = new ProtocolConverter(url, this.getCommandCodec(downstream), this.getResponseCodec(downstream), this.getCommandCodec(upstream), this.getResponseCodec(upstream));
                }
                Response response = result.createResponse();
                ServicedSession servicedSession = new ServicedSession(service, downstream, upstream, codec, new SessionId(response.getSessionId()), (Map)response.getValue());
                return servicedSession;
            }
            catch (IOException e) {
                throw new SessionNotCreatedException("Cannot establish new session", (Throwable)e);
            }
        }

        public String toString() {
            return this.getClass() + " (provider: " + this.serviceClassName + ")";
        }

        private CommandCodec<HttpRequest> getCommandCodec(Dialect dialect) {
            switch (dialect) {
                case OSS: {
                    return new JsonHttpCommandCodec();
                }
                case W3C: {
                    return new W3CHttpCommandCodec();
                }
            }
            throw new IllegalStateException("Unknown dialect: " + dialect);
        }

        private ResponseCodec<HttpResponse> getResponseCodec(Dialect dialect) {
            switch (dialect) {
                case OSS: {
                    return new JsonHttpResponseCodec();
                }
                case W3C: {
                    return new W3CHttpResponseCodec();
                }
            }
            throw new IllegalStateException("Unknown dialect: " + dialect);
        }
    }
}

