/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.grid.config.Config;

public class ConcatenatingConfig
implements Config {
    private final String prefix;
    private final char separator;
    private final Map<String, String> values;

    public ConcatenatingConfig(String prefix, char separator, Map<?, ?> values) {
        this.prefix = prefix == null || "".equals(prefix) ? "" : prefix + separator;
        this.separator = separator;
        this.values = (Map)Objects.requireNonNull(values).entrySet().stream().peek(entry -> Objects.requireNonNull(entry.getKey(), "Key has not been set")).peek(entry -> Objects.requireNonNull(entry.getValue(), "Value has not been set")).map(entry -> new AbstractMap.SimpleImmutableEntry<String, String>(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Optional<String> get(String section, String option) {
        String key = this.prefix + section + this.separator + option;
        return this.values.entrySet().stream().filter(entry -> key.equalsIgnoreCase((String)entry.getKey())).map(Map.Entry::getValue).findFirst();
    }
}

