/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.thoughtworks.selenium.SeleneseTestBase;
import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.webdriven.ElementFinder;
import com.thoughtworks.selenium.webdriven.JavascriptLibrary;
import com.thoughtworks.selenium.webdriven.commands.SeleniumSelect;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.server.htmlrunner.CoreRunnerError;
import org.openqa.selenium.server.htmlrunner.CoreStep;
import org.openqa.selenium.server.htmlrunner.CoreStepFactory;
import org.openqa.selenium.server.htmlrunner.NextStepDecorator;
import org.openqa.selenium.server.htmlrunner.TestState;

class NonReflectiveSteps {
    private static final Logger LOG = Logger.getLogger("Selenium Core Step");
    private static Supplier<ImmutableMap<String, CoreStepFactory>> STEPS = Suppliers.memoize(NonReflectiveSteps::build);

    NonReflectiveSteps() {
    }

    public ImmutableMap<String, CoreStepFactory> get() {
        return STEPS.get();
    }

    private static ImmutableMap<String, CoreStepFactory> build() {
        class SelectedOption
        implements CoreStep {
            private final String locator;
            private final String value;
            private final NextStepDecorator onFailure;

            public SelectedOption(String locator, String value, NextStepDecorator onFailure) {
                this.locator = locator;
                this.value = value;
                this.onFailure = onFailure;
            }

            @Override
            public NextStepDecorator execute(Selenium selenium, TestState state) {
                JavascriptLibrary library = new JavascriptLibrary();
                ElementFinder finder = new ElementFinder(library);
                SeleniumSelect select = new SeleniumSelect(library, finder, ((WrapsDriver)selenium).getWrappedDriver(), this.locator);
                WebElement element = select.findOption(this.value);
                if (element == null) {
                    return this.onFailure;
                }
                return NextStepDecorator.IDENTITY;
            }
        }
        ImmutableMap.Builder steps = ImmutableMap.builder();
        CoreStepFactory nextCommandFails = (locator, value) -> (selenium, state) -> new NextCommandFails(state.expand(locator));
        steps.put((Object)"assertErrorOnNext", (Object)nextCommandFails);
        steps.put((Object)"assertFailureOnNext", (Object)nextCommandFails);
        steps.put((Object)"sendKeys", (x$0, x$1) -> new SendKeys(x$0, x$1));
        steps.put((Object)"verifyErrorOnNext", (locator, value) -> (selenium, state) -> new VerifyNextCommandFails(state.expand(locator)));
        steps.put((Object)"verifyFailureOnNext", (locator, value) -> (selenium, state) -> new VerifyNextCommandFails(state.expand(locator)));
        steps.put((Object)"assertSelected", (locator, value) -> new SelectedOption(locator, value, NextStepDecorator.ASSERTION_FAILED(value + " not selected")));
        steps.put((Object)"verifySelected", (locator, value) -> new SelectedOption(locator, value, NextStepDecorator.VERIFICATION_FAILED(value + " not selected")));
        steps.put((Object)"echo", (locator, value) -> (selenium, state) -> {
            LOG.info(locator);
            return NextStepDecorator.IDENTITY;
        });
        steps.put((Object)"pause", (locator, value) -> (selenium, state) -> {
            try {
                long timeout = Long.parseLong(state.expand(locator));
                Thread.sleep(timeout);
                return NextStepDecorator.IDENTITY;
            }
            catch (NumberFormatException e) {
                return NextStepDecorator.ERROR(new SeleniumException("Unable to parse timeout: " + state.expand(locator)));
            }
            catch (InterruptedException e) {
                System.exit(255);
                throw new CoreRunnerError("We never get this far", new Object[0]);
            }
        });
        steps.put((Object)"store", (locator, value) -> (selenium, state) -> {
            state.store(state.expand(locator), state.expand(value));
            return NextStepDecorator.IDENTITY;
        });
        return steps.build();
    }

    private static class SendKeys
    implements CoreStep {
        private final String locator;
        private final String value;

        private SendKeys(String locator, String value) {
            this.locator = locator;
            this.value = value;
        }

        @Override
        public NextStepDecorator execute(Selenium selenium, TestState state) {
            String value = state.expand(this.value);
            value = value.replace("${KEY_ALT}", (CharSequence)Keys.ALT);
            value = value.replace("${KEY_CONTROL}", (CharSequence)Keys.CONTROL);
            value = value.replace("${KEY_CTRL}", (CharSequence)Keys.CONTROL);
            value = value.replace("${KEY_META}", (CharSequence)Keys.META);
            value = value.replace("${KEY_COMMAND}", (CharSequence)Keys.COMMAND);
            value = value.replace("${KEY_SHIFT}", (CharSequence)Keys.SHIFT);
            value = value.replace("${KEY_BACKSPACE}", (CharSequence)Keys.BACK_SPACE);
            value = value.replace("${KEY_BKSP}", (CharSequence)Keys.BACK_SPACE);
            value = value.replace("${KEY_DELETE}", (CharSequence)Keys.DELETE);
            value = value.replace("${KEY_DEL}", (CharSequence)Keys.DELETE);
            value = value.replace("${KEY_ENTER}", (CharSequence)Keys.ENTER);
            value = value.replace("${KEY_EQUALS}", (CharSequence)Keys.EQUALS);
            value = value.replace("${KEY_ESCAPE}", (CharSequence)Keys.ESCAPE);
            value = value.replace("${KEY_ESC}", (CharSequence)Keys.ESCAPE);
            value = value.replace("${KEY_INSERT}", (CharSequence)Keys.INSERT);
            value = value.replace("${KEY_INS}", (CharSequence)Keys.INSERT);
            value = value.replace("${KEY_PAUSE}", (CharSequence)Keys.PAUSE);
            value = value.replace("${KEY_SEMICOLON}", (CharSequence)Keys.SEMICOLON);
            value = value.replace("${KEY_SPACE}", (CharSequence)Keys.SPACE);
            value = value.replace("${KEY_TAB}", (CharSequence)Keys.TAB);
            value = value.replace("${KEY_LEFT}", (CharSequence)Keys.LEFT);
            value = value.replace("${KEY_UP}", (CharSequence)Keys.UP);
            value = value.replace("${KEY_RIGHT}", (CharSequence)Keys.RIGHT);
            value = value.replace("${KEY_DOWN}", (CharSequence)Keys.DOWN);
            value = value.replace("${KEY_PAGE_UP}", (CharSequence)Keys.PAGE_UP);
            value = value.replace("${KEY_PGUP}", (CharSequence)Keys.PAGE_UP);
            value = value.replace("${KEY_PAGE_DOWN}", (CharSequence)Keys.PAGE_DOWN);
            value = value.replace("${KEY_PGDN}", (CharSequence)Keys.PAGE_DOWN);
            value = value.replace("${KEY_END}", (CharSequence)Keys.END);
            value = value.replace("${KEY_HOME}", (CharSequence)Keys.HOME);
            value = value.replace("${KEY_NUMPAD0}", (CharSequence)Keys.NUMPAD0);
            value = value.replace("${KEY_N0}", (CharSequence)Keys.NUMPAD0);
            value = value.replace("${KEY_NUMPAD1}", (CharSequence)Keys.NUMPAD1);
            value = value.replace("${KEY_N1}", (CharSequence)Keys.NUMPAD1);
            value = value.replace("${KEY_NUMPAD2}", (CharSequence)Keys.NUMPAD2);
            value = value.replace("${KEY_N2}", (CharSequence)Keys.NUMPAD2);
            value = value.replace("${KEY_NUMPAD3}", (CharSequence)Keys.NUMPAD3);
            value = value.replace("${KEY_N3}", (CharSequence)Keys.NUMPAD3);
            value = value.replace("${KEY_NUMPAD4}", (CharSequence)Keys.NUMPAD4);
            value = value.replace("${KEY_N4}", (CharSequence)Keys.NUMPAD4);
            value = value.replace("${KEY_NUMPAD5}", (CharSequence)Keys.NUMPAD5);
            value = value.replace("${KEY_N5}", (CharSequence)Keys.NUMPAD5);
            value = value.replace("${KEY_NUMPAD6}", (CharSequence)Keys.NUMPAD6);
            value = value.replace("${KEY_N6}", (CharSequence)Keys.NUMPAD6);
            value = value.replace("${KEY_NUMPAD7}", (CharSequence)Keys.NUMPAD7);
            value = value.replace("${KEY_N7}", (CharSequence)Keys.NUMPAD7);
            value = value.replace("${KEY_NUMPAD8}", (CharSequence)Keys.NUMPAD8);
            value = value.replace("${KEY_N8}", (CharSequence)Keys.NUMPAD8);
            value = value.replace("${KEY_NUMPAD9}", (CharSequence)Keys.NUMPAD9);
            value = value.replace("${KEY_N9}", (CharSequence)Keys.NUMPAD9);
            value = value.replace("${KEY_ADD}", (CharSequence)Keys.ADD);
            value = value.replace("${KEY_NUM_PLUS}", (CharSequence)Keys.ADD);
            value = value.replace("${KEY_DECIMAL}", (CharSequence)Keys.DECIMAL);
            value = value.replace("${KEY_NUM_PERIOD}", (CharSequence)Keys.DECIMAL);
            value = value.replace("${KEY_DIVIDE}", (CharSequence)Keys.DIVIDE);
            value = value.replace("${KEY_NUM_DIVISION}", (CharSequence)Keys.DIVIDE);
            value = value.replace("${KEY_MULTIPLY}", (CharSequence)Keys.MULTIPLY);
            value = value.replace("${KEY_NUM_MULTIPLY}", (CharSequence)Keys.MULTIPLY);
            value = value.replace("${KEY_SEPARATOR}", (CharSequence)Keys.SEPARATOR);
            value = value.replace("${KEY_SEP}", (CharSequence)Keys.SEPARATOR);
            value = value.replace("${KEY_SUBTRACT}", (CharSequence)Keys.SUBTRACT);
            value = value.replace("${KEY_NUM_MINUS}", (CharSequence)Keys.SUBTRACT);
            value = value.replace("${KEY_F1}", (CharSequence)Keys.F1);
            value = value.replace("${KEY_F2}", (CharSequence)Keys.F2);
            value = value.replace("${KEY_F3}", (CharSequence)Keys.F3);
            value = value.replace("${KEY_F4}", (CharSequence)Keys.F4);
            value = value.replace("${KEY_F5}", (CharSequence)Keys.F5);
            value = value.replace("${KEY_F6}", (CharSequence)Keys.F6);
            value = value.replace("${KEY_F7}", (CharSequence)Keys.F7);
            value = value.replace("${KEY_F8}", (CharSequence)Keys.F8);
            value = value.replace("${KEY_F9}", (CharSequence)Keys.F9);
            value = value.replace("${KEY_F10}", (CharSequence)Keys.F10);
            value = value.replace("${KEY_F11}", (CharSequence)Keys.F11);
            value = value.replace("${KEY_F12}", (CharSequence)Keys.F12);
            selenium.typeKeys(this.locator, value);
            return NextStepDecorator.IDENTITY;
        }
    }

    private static class VerifyNextCommandFails
    extends NextStepDecorator {
        private final String assertion;

        public VerifyNextCommandFails(String assertion) {
            this.assertion = assertion;
        }

        @Override
        public NextStepDecorator evaluate(CoreStep nextStep, Selenium selenium, TestState state) {
            NextStepDecorator actualResult = nextStep.execute(selenium, state);
            Throwable cause = actualResult.getCause();
            if (cause == null) {
                return NextStepDecorator.VERIFICATION_FAILED("Expected command to fail");
            }
            if (!(cause instanceof SeleniumException)) {
                return actualResult;
            }
            try {
                SeleneseTestBase.assertEquals(this.assertion, cause.getMessage());
                return NextStepDecorator.IDENTITY;
            }
            catch (AssertionError e) {
                return NextStepDecorator.VERIFICATION_FAILED(((Throwable)((Object)e)).getMessage());
            }
        }

        @Override
        public boolean isOkayToContinueTest() {
            return true;
        }
    }

    private static class NextCommandFails
    extends NextStepDecorator {
        private final String assertion;

        public NextCommandFails(String assertion) {
            this.assertion = assertion;
        }

        @Override
        public NextStepDecorator evaluate(CoreStep nextStep, Selenium selenium, TestState state) {
            NextStepDecorator actualResult = nextStep.execute(selenium, state);
            Throwable cause = actualResult.getCause();
            if (cause == null) {
                return NextStepDecorator.ASSERTION_FAILED("Expected command to fail");
            }
            if (!(cause instanceof SeleniumException)) {
                return actualResult;
            }
            try {
                SeleneseTestBase.assertEquals(this.assertion, cause.getMessage());
                return NextStepDecorator.IDENTITY;
            }
            catch (AssertionError e) {
                return NextStepDecorator.ASSERTION_FAILED(((Throwable)((Object)e)).getMessage());
            }
        }

        @Override
        public boolean isOkayToContinueTest() {
            return true;
        }
    }
}

