/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.webdriven;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableMap;
import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.webdriven.WebDriverCommandProcessor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.DefaultDriverSessions;
import org.openqa.selenium.remote.server.DriverServlet;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.Session;

public class WebDriverBackedSeleniumServlet
extends HttpServlet {
    private static final Random UUID_SEED = new Random();
    static Cache<SessionId, CommandProcessor> SESSIONS = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<SessionId, CommandProcessor>(){

        public void onRemoval(RemovalNotification<SessionId, CommandProcessor> notification) {
            CommandProcessor holder = (CommandProcessor)notification.getValue();
            if (holder != null) {
                try {
                    holder.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }).build();
    private final ImmutableMap<String, DesiredCapabilities> drivers = ImmutableMap.builder().put((Object)"*firefoxproxy", (Object)DesiredCapabilities.firefox()).put((Object)"*firefox", (Object)DesiredCapabilities.firefox()).put((Object)"*chrome", (Object)DesiredCapabilities.firefox()).put((Object)"*firefoxchrome", (Object)DesiredCapabilities.firefox()).put((Object)"*iexploreproxy", (Object)DesiredCapabilities.internetExplorer()).put((Object)"*safari", (Object)DesiredCapabilities.safari()).put((Object)"*iehta", (Object)DesiredCapabilities.internetExplorer()).put((Object)"*iexplore", (Object)DesiredCapabilities.internetExplorer()).put((Object)"*googlechrome", (Object)DesiredCapabilities.chrome()).build();
    private final Supplier<DriverSessions> sessionsSupplier = new Supplier<DriverSessions>(){

        public DriverSessions get() {
            Object attribute = WebDriverBackedSeleniumServlet.this.getServletContext().getAttribute(DriverServlet.SESSIONS_KEY);
            if (attribute == null) {
                attribute = new DefaultDriverSessions();
            }
            return (DriverSessions)attribute;
        }
    };

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String cmd = req.getParameter("cmd");
        SessionId sessionId = new SessionId(req.getParameter("sessionId"));
        Object[] args = this.deserializeArgs(req);
        if (cmd == null) {
            resp.sendError(404);
            return;
        }
        StringBuilder printableArgs = new StringBuilder("[");
        Joiner.on((String)", ").appendTo(printableArgs, args);
        printableArgs.append("]");
        this.getServletContext().log(String.format("Command request: %s%s on session %s", cmd, printableArgs, sessionId));
        if ("getNewBrowserSession".equals(cmd)) {
            this.startNewSession(resp, (String)args[0], (String)args[1], (String)(args.length == 4 ? args[3] : ""));
            return;
        }
        if ("testComplete".equals(cmd)) {
            ((DriverSessions)this.sessionsSupplier.get()).deleteSession(sessionId);
            CommandProcessor commandProcessor = (CommandProcessor)SESSIONS.getIfPresent((Object)sessionId);
            if (commandProcessor == null) {
                resp.sendError(404);
                return;
            }
            SESSIONS.invalidate((Object)sessionId);
            this.sendResponse(resp, null);
            return;
        }
        CommandProcessor commandProcessor = (CommandProcessor)SESSIONS.getIfPresent((Object)sessionId);
        if (commandProcessor == null) {
            resp.sendError(404);
            return;
        }
        try {
            String result = commandProcessor.doCommand(cmd, (String[])args);
            this.sendResponse(resp, result);
        }
        catch (SeleniumException e) {
            this.sendError(resp, e.getMessage());
        }
    }

    private void startNewSession(HttpServletResponse resp, String browserString, String baseUrl, String options) throws IOException {
        Session session;
        SessionId sessionId = null;
        if (options.startsWith("webdriver.remote.sessionid")) {
            List split = Splitter.on((String)"=").omitEmptyStrings().trimResults().limit(2).splitToList((CharSequence)options);
            if (!"webdriver.remote.sessionid".equals(split.get(0))) {
                this.getServletContext().log("Unable to find existing webdriver session. Wrong parameter name: " + options);
                this.sendError(resp, "Unable to find existing webdriver session. Wrong parameter name: " + options);
                return;
            }
            if (split.size() != 2) {
                this.getServletContext().log("Attempted to find webdriver id, but none specified. Bailing");
                this.sendError(resp, "Unable to find existing webdriver session. No ID specified");
                return;
            }
            sessionId = new SessionId((String)split.get(1));
        }
        if (sessionId == null) {
            DesiredCapabilities caps;
            switch (browserString) {
                case "*webdriver": {
                    caps = new DesiredCapabilities();
                    break;
                }
                case "*chrome": 
                case "*firefox": 
                case "*firefoxproxy": 
                case "*firefoxchrome": 
                case "*pifirefox": {
                    caps = DesiredCapabilities.firefox();
                    break;
                }
                case "*iehta": 
                case "*iexplore": 
                case "*iexploreproxy": 
                case "*piiexplore": {
                    caps = DesiredCapabilities.internetExplorer();
                    break;
                }
                case "*googlechrome": {
                    caps = DesiredCapabilities.chrome();
                    break;
                }
                case "*MicrosoftEdge": {
                    caps = DesiredCapabilities.edge();
                    break;
                }
                case "*opera": 
                case "*operablink": {
                    caps = DesiredCapabilities.operaBlink();
                    break;
                }
                case "*safari": 
                case "*safariproxy": {
                    caps = DesiredCapabilities.safari();
                    break;
                }
                default: {
                    this.sendError(resp, "Unable to match browser string: " + browserString);
                    return;
                }
            }
            try {
                sessionId = ((DriverSessions)this.sessionsSupplier.get()).newSession((Capabilities)caps);
            }
            catch (Exception e) {
                this.getServletContext().log("Unable to start session", (Throwable)e);
                this.sendError(resp, "Unable to start session. Cause can be found in logs. Message is: " + e.getMessage());
                return;
            }
        }
        if ((session = ((DriverSessions)this.sessionsSupplier.get()).get(sessionId)) == null) {
            this.getServletContext().log("Attempt to use non-existant session: " + sessionId);
            this.sendError(resp, "Attempt to use non-existant session: " + sessionId);
            return;
        }
        WebDriver driver = session.getDriver();
        WebDriverCommandProcessor commandProcessor = new WebDriverCommandProcessor(baseUrl, driver);
        SESSIONS.put((Object)sessionId, (Object)commandProcessor);
        this.sendResponse(resp, sessionId.toString());
    }

    private void sendResponse(HttpServletResponse resp, String result) throws IOException {
        resp.setStatus(200);
        resp.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
        resp.getWriter().append("OK").append(result == null ? "" : "," + result);
        resp.flushBuffer();
    }

    private void sendError(HttpServletResponse resp, String result) throws IOException {
        resp.setStatus(200);
        resp.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
        resp.getWriter().append("ERROR").append(result == null ? "" : ": " + result);
        resp.flushBuffer();
    }

    private String[] deserializeArgs(HttpServletRequest req) {
        String value;
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 0; i < 5 && (value = req.getParameter(String.valueOf(i + 1))) != null; ++i) {
            args.add(value);
        }
        return args.toArray(new String[args.size()]);
    }
}

