/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.thoughtworks.selenium.SeleneseTestBase;
import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.webdriven.ElementFinder;
import com.thoughtworks.selenium.webdriven.JavascriptLibrary;
import com.thoughtworks.selenium.webdriven.commands.SeleniumSelect;
import java.util.logging.Logger;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.server.htmlrunner.CoreRunnerError;
import org.openqa.selenium.server.htmlrunner.CoreStep;
import org.openqa.selenium.server.htmlrunner.CoreStepFactory;
import org.openqa.selenium.server.htmlrunner.NextStepDecorator;
import org.openqa.selenium.server.htmlrunner.TestState;

class NonReflectiveSteps {
    private static final Logger LOG = Logger.getLogger("Selenium Core Step");
    private static Supplier<ImmutableMap<String, CoreStepFactory>> STEPS = Suppliers.memoize(NonReflectiveSteps::build);

    NonReflectiveSteps() {
    }

    public ImmutableMap<String, CoreStepFactory> get() {
        return (ImmutableMap)STEPS.get();
    }

    private static ImmutableMap<String, CoreStepFactory> build() {
        class SelectedOption
        implements CoreStep {
            private final String locator;
            private final String value;
            private final NextStepDecorator onFailure;

            public SelectedOption(String locator, String value, NextStepDecorator onFailure) {
                this.locator = locator;
                this.value = value;
                this.onFailure = onFailure;
            }

            @Override
            public NextStepDecorator execute(Selenium selenium, TestState state) {
                JavascriptLibrary library = new JavascriptLibrary();
                ElementFinder finder = new ElementFinder(library);
                SeleniumSelect select = new SeleniumSelect(library, finder, ((WrapsDriver)selenium).getWrappedDriver(), this.locator);
                WebElement element = select.findOption(this.value);
                if (element == null) {
                    return this.onFailure;
                }
                return NextStepDecorator.IDENTITY;
            }
        }
        ImmutableMap.Builder steps = ImmutableMap.builder();
        CoreStepFactory nextCommandFails = (locator, value) -> (selenium, state) -> new NextCommandFails(state.expand(locator));
        steps.put((Object)"assertErrorOnNext", (Object)nextCommandFails);
        steps.put((Object)"assertFailureOnNext", (Object)nextCommandFails);
        steps.put((Object)"verifyErrorOnNext", (locator, value) -> (selenium, state) -> new VerifyNextCommandFails(state.expand(locator)));
        steps.put((Object)"verifyFailureOnNext", (locator, value) -> (selenium, state) -> new VerifyNextCommandFails(state.expand(locator)));
        steps.put((Object)"assertSelected", (locator, value) -> new SelectedOption(locator, value, NextStepDecorator.ASSERTION_FAILED(value + " not selected")));
        steps.put((Object)"verifySelected", (locator, value) -> new SelectedOption(locator, value, NextStepDecorator.VERIFICATION_FAILED(value + " not selected")));
        steps.put((Object)"echo", (locator, value) -> (selenium, state) -> {
            LOG.info(locator);
            return NextStepDecorator.IDENTITY;
        });
        steps.put((Object)"pause", (locator, value) -> (selenium, state) -> {
            try {
                long timeout = Long.parseLong(state.expand(locator));
                Thread.sleep(timeout);
                return NextStepDecorator.IDENTITY;
            }
            catch (NumberFormatException e) {
                return NextStepDecorator.ERROR(new SeleniumException("Unable to parse timeout: " + state.expand(locator)));
            }
            catch (InterruptedException e) {
                System.exit(255);
                throw new CoreRunnerError("We never get this far", new Object[0]);
            }
        });
        steps.put((Object)"store", (locator, value) -> (selenium, state) -> {
            state.store(state.expand(locator), state.expand(value));
            return NextStepDecorator.IDENTITY;
        });
        return steps.build();
    }

    private static class VerifyNextCommandFails
    extends NextStepDecorator {
        private final String assertion;

        public VerifyNextCommandFails(String assertion) {
            this.assertion = assertion;
        }

        @Override
        public NextStepDecorator evaluate(CoreStep nextStep, Selenium selenium, TestState state) {
            NextStepDecorator actualResult = nextStep.execute(selenium, state);
            Throwable cause = actualResult.getCause();
            if (cause == null) {
                return NextStepDecorator.VERIFICATION_FAILED("Expected command to fail");
            }
            if (!(cause instanceof SeleniumException)) {
                return actualResult;
            }
            try {
                SeleneseTestBase.assertEquals(this.assertion, cause.getMessage());
                return NextStepDecorator.IDENTITY;
            }
            catch (AssertionError e) {
                return NextStepDecorator.VERIFICATION_FAILED(((Throwable)((Object)e)).getMessage());
            }
        }

        @Override
        public boolean isOkayToContinueTest() {
            return true;
        }
    }

    private static class NextCommandFails
    extends NextStepDecorator {
        private final String assertion;

        public NextCommandFails(String assertion) {
            this.assertion = assertion;
        }

        @Override
        public NextStepDecorator evaluate(CoreStep nextStep, Selenium selenium, TestState state) {
            NextStepDecorator actualResult = nextStep.execute(selenium, state);
            Throwable cause = actualResult.getCause();
            if (cause == null) {
                return NextStepDecorator.ASSERTION_FAILED("Expected command to fail");
            }
            if (!(cause instanceof SeleniumException)) {
                return actualResult;
            }
            try {
                SeleneseTestBase.assertEquals(this.assertion, cause.getMessage());
                return NextStepDecorator.IDENTITY;
            }
            catch (AssertionError e) {
                return NextStepDecorator.ASSERTION_FAILED(((Throwable)((Object)e)).getMessage());
            }
        }

        @Override
        public boolean isOkayToContinueTest() {
            return true;
        }
    }
}

