/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.server.htmlrunner.CoreStep;
import org.openqa.selenium.server.htmlrunner.CoreStepFactory;
import org.openqa.selenium.server.htmlrunner.NextStepDecorator;
import org.openqa.selenium.server.htmlrunner.NonReflectiveSteps;
import org.openqa.selenium.server.htmlrunner.ReflectivelyDiscoveredSteps;
import org.openqa.selenium.server.htmlrunner.Results;
import org.openqa.selenium.server.htmlrunner.TestState;

public class CoreTestCase {
    private static final Logger LOG = Logger.getLogger(CoreTestCase.class.getName());
    private static final ImmutableMap<String, CoreStepFactory> STEP_FACTORY = ImmutableMap.builder().putAll(new ReflectivelyDiscoveredSteps().get()).putAll(new NonReflectiveSteps().get()).build();
    private String url;

    public CoreTestCase(String url) {
        this.url = (String)Preconditions.checkNotNull((Object)url);
    }

    public void run(Results results, WebDriver driver, Selenium selenium) {
        String currentUrl = driver.getCurrentUrl();
        if (!this.url.equals(currentUrl)) {
            driver.get(this.url);
        }
        List<LoggableStep> steps = this.findCommands(driver);
        String rawSource = this.getLoggableTests(driver);
        TestState state = new TestState();
        ArrayList<StepResult> stepResults = new ArrayList<StepResult>(steps.size());
        NextStepDecorator decorator = NextStepDecorator.IDENTITY;
        for (LoggableStep step : steps) {
            LOG.info(step.toString());
            decorator = (NextStepDecorator)Preconditions.checkNotNull((Object)decorator.evaluate(step, selenium, state), (Object)step);
            stepResults.add(new StepResult(step, decorator.getCause()));
            if (!decorator.isOkayToContinueTest()) break;
            state.sleepTight();
        }
        results.addTest(rawSource, stepResults);
    }

    private String getLoggableTests(WebDriver driver) {
        return (String)((JavascriptExecutor)driver).executeScript(Joiner.on((String)"\n").join((Object)"var resultHTML = document.body.innerHTML;", (Object)"if (!resultHTML) { return ''; }", new Object[]{"var trElement = document.createElement('tr');", "var divElement = document.createElement('div');", "divElement.innerHTML = resultHTML;", "var cell = document.createElement('td');", "cell.appendChild(divElement);", "trElement.appendChild(cell);", "return trElement.outerHTML;"}), new Object[0]);
    }

    private List<LoggableStep> findCommands(WebDriver driver) {
        List rawSteps = (List)((JavascriptExecutor)driver).executeScript("var toReturn = [];\nvar tables = document.getElementsByTagName('table');\nfor (var i = 0; i < tables.length; i++) {  for (var rowCount = 0; rowCount < tables[i].rows.length; rowCount++) {\n    if (tables[i].rows[rowCount].cells.length < 3) {\n      continue;\n    }\n    var cells = tables[i].rows[rowCount].cells;\n    toReturn.push([cells[0].textContent.trim(), cells[1].textContent.trim(), cells[2].textContent.trim()]);\n    tables[i].rows[rowCount].className += 'insert-core-result';\n  }\n}\nreturn toReturn;", new Object[0]);
        ImmutableList.Builder steps = ImmutableList.builder();
        for (List step : rawSteps) {
            if (!STEP_FACTORY.containsKey(step.get(0))) {
                throw new SeleniumException("Unknown command: " + (String)step.get(0));
            }
            steps.add((Object)new LoggableStep(((CoreStepFactory)STEP_FACTORY.get(step.get(0))).create((String)step.get(1), (String)step.get(2)), (String)step.get(0), (String)step.get(1), (String)step.get(2)));
        }
        return steps.build();
    }

    static class StepResult {
        private final LoggableStep step;
        private final Throwable cause;
        private final String renderableClass;

        public StepResult(LoggableStep step, Throwable cause) {
            this.step = (LoggableStep)Preconditions.checkNotNull((Object)step);
            this.cause = cause;
            this.renderableClass = cause == null ? (step.command.startsWith("verify") || step.command.startsWith("assert") ? "status_passed" : "status_done") : "status_failed";
        }

        public String getRenderableClass() {
            return this.renderableClass;
        }

        public boolean isSuccessful() {
            return this.cause == null;
        }

        public boolean isError() {
            return this.cause instanceof SeleniumException;
        }

        public boolean isFailure() {
            return !this.isSuccessful() && !this.isError();
        }

        public String getStepLog() {
            return this.step.toString();
        }
    }

    private static class LoggableStep
    implements CoreStep {
        private final CoreStep actualStep;
        private final String command;
        private final String locator;
        private final String value;

        public LoggableStep(CoreStep toWrap, String command, String locator, String value) {
            this.actualStep = toWrap;
            this.command = command;
            this.locator = locator.replace('\u00a0', ' ');
            this.value = value.replace('\u00a0', ' ');
        }

        @Override
        public NextStepDecorator execute(Selenium selenium, TestState state) {
            return this.actualStep.execute(selenium, state);
        }

        public String toString() {
            return String.format("|%s | %s | %s |", this.command, this.locator, this.value);
        }
    }
}

