/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonTypeCoercer;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;

class CollectionCoercer<T extends Collection, I extends T>
extends TypeCoercer<T> {
    private final Class<T> stereotype;
    private final JsonTypeCoercer coercer;
    private final Supplier<I> supplier;
    private final Function<I, Consumer<Object>> consumerFactory;

    public CollectionCoercer(Class<T> stereotype, JsonTypeCoercer coercer, Supplier<I> supplier, Function<I, Consumer<Object>> consumerFactory) {
        this.stereotype = (Class)Require.nonNull((String)"Stereotype", stereotype);
        this.coercer = (JsonTypeCoercer)Require.nonNull((String)"Coercer", (Object)coercer);
        this.supplier = (Supplier)Require.nonNull((String)"Supplier", supplier);
        this.consumerFactory = (Function)Require.nonNull((String)"Consumer factory", consumerFactory);
    }

    @Override
    public boolean test(Class<?> aClass) {
        return this.stereotype.isAssignableFrom(aClass);
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, T> apply(Type type) {
        Object valueType;
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            valueType = pt.getActualTypeArguments()[0];
        } else if (type instanceof Class) {
            valueType = Object.class;
        } else {
            throw new IllegalArgumentException("Unhandled type: " + String.valueOf(type.getClass()));
        }
        return (arg_0, arg_1) -> this.lambda$apply$0((Type)valueType, arg_0, arg_1);
    }

    private /* synthetic */ Collection lambda$apply$0(Type valueType, JsonInput jsonInput, PropertySetting setting) {
        jsonInput.beginArray();
        Collection toReturn = (Collection)this.supplier.get();
        Consumer<Object> consumer = this.consumerFactory.apply(toReturn);
        while (jsonInput.hasNext()) {
            consumer.accept(this.coercer.coerce(jsonInput, valueType, setting));
        }
        jsonInput.endArray();
        return toReturn;
    }
}

