/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebDriverBuilder;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverFinder;
import org.openqa.selenium.remote.service.DriverService;

public class InternetExplorerDriver
extends RemoteWebDriver {
    public static final String IGNORE_ZOOM_SETTING = "ignoreZoomSetting";
    public static final String INITIAL_BROWSER_URL = "initialBrowserUrl";
    public static final String ELEMENT_SCROLL_BEHAVIOR = "elementScrollBehavior";
    public static final String ENABLE_ELEMENT_CACHE_CLEANUP = "enableElementCacheCleanup";
    public static final String BROWSER_ATTACH_TIMEOUT = "browserAttachTimeout";
    public static final String INTRODUCE_FLAKINESS_BY_IGNORING_SECURITY_DOMAINS = "ignoreProtectedModeSettings";
    public static final String ENABLE_PERSISTENT_HOVERING = "enablePersistentHover";
    public static final String REQUIRE_WINDOW_FOCUS = "requireWindowFocus";
    public static final String FORCE_CREATE_PROCESS = "ie.forceCreateProcessApi";
    public static final String IE_ENSURE_CLEAN_SESSION = "ie.ensureCleanSession";
    public static final String IE_USE_PER_PROCESS_PROXY = "ie.usePerProcessProxy";
    public static final String IE_SWITCHES = "ie.browserCommandLineSwitches";

    public InternetExplorerDriver() {
        this(InternetExplorerDriverService.createDefaultService(), new InternetExplorerOptions(), ClientConfig.defaultConfig());
    }

    public InternetExplorerDriver(InternetExplorerOptions options) {
        this(options, ClientConfig.defaultConfig());
    }

    public InternetExplorerDriver(InternetExplorerOptions options, ClientConfig clientConfig) {
        this(InternetExplorerDriverService.createDefaultService(), options, clientConfig);
    }

    public InternetExplorerDriver(InternetExplorerDriverService service) {
        this(service, new InternetExplorerOptions(), ClientConfig.defaultConfig());
    }

    public InternetExplorerDriver(InternetExplorerDriverService service, InternetExplorerOptions options) {
        this(service, options, ClientConfig.defaultConfig());
    }

    public InternetExplorerDriver(@Nullable InternetExplorerDriverService service, @Nullable InternetExplorerOptions options, ClientConfig clientConfig) {
        options = options == null ? new InternetExplorerOptions() : options;
        service = service == null ? InternetExplorerDriverService.createDefaultService() : service;
        Require.nonNull((String)"Client config", (Object)clientConfig);
        service.setExecutable(new DriverFinder((DriverService)service, (Capabilities)options).getDriverPath());
        this.assertOnWindows();
        this.setCommandExecutor((CommandExecutor)new DriverCommandExecutor((DriverService)service, clientConfig));
        this.startSession((Capabilities)options);
    }

    @Beta
    public static RemoteWebDriverBuilder builder() {
        return RemoteWebDriver.builder().oneOf((Capabilities)new InternetExplorerOptions(), new Capabilities[0]);
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    protected void assertOnWindows() {
        Platform current = Platform.getCurrent();
        if (!current.is(Platform.WINDOWS)) {
            throw new WebDriverException(String.format("You appear to be running %s. The IE driver only runs on Windows.", current));
        }
    }
}

