/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import com.google.auto.service.AutoService;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.Browser;

@AutoService(value={WebDriverInfo.class})
public class InternetExplorerDriverInfo
implements WebDriverInfo {
    public String getDisplayName() {
        return "Internet Explorer";
    }

    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", (Object)Browser.IE.browserName());
    }

    public boolean isSupporting(Capabilities capabilities) {
        return Browser.IE.is(capabilities) || capabilities.getCapability("se:ieOptions") != null;
    }

    public boolean isSupportingCdp() {
        return false;
    }

    public boolean isAvailable() {
        try {
            InternetExplorerDriverService.createDefaultService();
            return true;
        }
        catch (IllegalStateException | WebDriverException e) {
            return false;
        }
    }

    public int getMaximumSimultaneousSessions() {
        return 1;
    }

    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable()) {
            return Optional.empty();
        }
        return Optional.of(new InternetExplorerDriver(new InternetExplorerOptions().merge(capabilities)));
    }
}

