/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.NativeLongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.ie.ErrorHandler;
import org.openqa.selenium.ie.ExportedWebDriverFunctions;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerElement;
import org.openqa.selenium.ie.StringWrapper;

public class JavascriptResultCollection {
    private ExportedWebDriverFunctions lib;
    ErrorHandler errors;
    InternetExplorerDriver parent;

    public JavascriptResultCollection(ExportedWebDriverFunctions lib, InternetExplorerDriver parent) {
        this.lib = lib;
        this.parent = parent;
        this.errors = new ErrorHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractReturnValue(PointerByReference scriptResultRef) {
        Pointer scriptResult = scriptResultRef.getValue();
        Pointer driver = this.parent.getDriverPointer();
        IntByReference type = new IntByReference();
        int result = this.lib.wdGetScriptResultType(driver, scriptResult, type);
        this.errors.verifyErrorCode(result, "Cannot determine result type");
        try {
            ArrayList<Object> toReturn;
            switch (type.getValue()) {
                case 1: {
                    PointerByReference wrapper = new PointerByReference();
                    result = this.lib.wdGetStringScriptResult(scriptResult, wrapper);
                    this.errors.verifyErrorCode(result, "Cannot extract string result");
                    toReturn = new StringWrapper(this.lib, wrapper).toString();
                    break;
                }
                case 2: {
                    NativeLongByReference value = new NativeLongByReference();
                    result = this.lib.wdGetNumberScriptResult(scriptResult, value);
                    this.errors.verifyErrorCode(result, "Cannot extract number result");
                    toReturn = value.getValue().longValue();
                    break;
                }
                case 3: {
                    IntByReference boolVal = new IntByReference();
                    result = this.lib.wdGetBooleanScriptResult(scriptResult, boolVal);
                    this.errors.verifyErrorCode(result, "Cannot extract boolean result");
                    toReturn = boolVal.getValue() == 1 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 4: {
                    PointerByReference element = new PointerByReference();
                    result = this.lib.wdGetElementScriptResult(scriptResult, driver, element);
                    this.errors.verifyErrorCode(result, "Cannot extract element result");
                    toReturn = new InternetExplorerElement(this.lib, this.parent, element.getValue());
                    break;
                }
                case 5: {
                    toReturn = null;
                    break;
                }
                case 6: {
                    PointerByReference message = new PointerByReference();
                    result = this.lib.wdGetStringScriptResult(scriptResult, message);
                    this.errors.verifyErrorCode(result, "Cannot extract string result");
                    throw new WebDriverException(new StringWrapper(this.lib, message).toString());
                }
                case 7: {
                    DoubleByReference doubleVal = new DoubleByReference();
                    result = this.lib.wdGetDoubleScriptResult(scriptResult, doubleVal);
                    this.errors.verifyErrorCode(result, "Cannot extract double result");
                    toReturn = doubleVal.getValue();
                    break;
                }
                case 8: {
                    IntByReference arrayLength = new IntByReference();
                    result = this.lib.wdGetArrayLengthScriptResult(driver, scriptResult, arrayLength);
                    this.errors.verifyErrorCode(result, "Cannot extract array length.");
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (int i = 0; i < arrayLength.getValue(); ++i) {
                        PointerByReference currItem = new PointerByReference();
                        int getItemResult = this.lib.wdGetArrayItemFromScriptResult(driver, scriptResult, i, currItem);
                        if (getItemResult != 0) {
                            this.lib.wdFreeScriptResult(currItem.getValue());
                            throw new IllegalStateException(String.format("Cannot extract element from collection at index: %d (%d)", i, result));
                        }
                        list.add(this.extractReturnValue(currItem));
                    }
                    toReturn = list;
                    break;
                }
                default: {
                    throw new WebDriverException("Cannot determine result type");
                }
            }
            Double d = toReturn;
            return d;
        }
        finally {
            this.lib.wdFreeScriptResult(scriptResult);
        }
    }
}

