/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Speed;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.browserlaunchers.WindowsProxyManager;
import org.openqa.selenium.ie.ErrorHandler;
import org.openqa.selenium.ie.ExportedWebDriverFunctions;
import org.openqa.selenium.ie.Finder;
import org.openqa.selenium.ie.InternetExplorerElement;
import org.openqa.selenium.ie.JavascriptResultCollection;
import org.openqa.selenium.ie.StringCollection;
import org.openqa.selenium.ie.StringWrapper;
import org.openqa.selenium.internal.FileHandler;
import org.openqa.selenium.internal.ReturnedCookie;
import org.openqa.selenium.internal.TemporaryFilesystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternetExplorerDriver
implements WebDriver,
JavascriptExecutor,
TakesScreenshot {
    private static ExportedWebDriverFunctions lib;
    private Pointer driver;
    private Speed speed = Speed.FAST;
    private ErrorHandler errors = new ErrorHandler();
    private Thread cleanupThread;
    private WindowsProxyManager proxyManager = new WindowsProxyManager(true, "webdriver-ie", 0, 0);

    public InternetExplorerDriver() {
        this(null);
    }

    public InternetExplorerDriver(Capabilities caps) {
        this.prepareProxy(caps);
        this.initializeLib();
        PointerByReference ptr = new PointerByReference();
        int result = lib.wdNewDriverInstance(ptr);
        if (result != 0) {
            throw new IllegalStateException("Cannot create new browser instance: " + result);
        }
        this.driver = ptr.getValue();
    }

    private void prepareProxy(Capabilities caps) {
        if (caps == null || caps.getCapability("proxy") == null) {
            return;
        }
        try {
            this.proxyManager.backupRegistrySettings();
            this.proxyManager.changeRegistrySettings(caps);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        this.cleanupThread = new Thread(){

            public void run() {
                InternetExplorerDriver.this.proxyManager.restoreRegistrySettings(true);
            }
        };
        Runtime.getRuntime().addShutdownHook(this.cleanupThread);
    }

    public String getPageSource() {
        PointerByReference wrapper = new PointerByReference();
        int result = lib.wdGetPageSource(this.driver, wrapper);
        this.errors.verifyErrorCode(result, "Unable to get page source");
        return new StringWrapper(lib, wrapper).toString();
    }

    public void close() {
        int result = lib.wdClose(this.driver);
        if (result != 0) {
            throw new IllegalStateException("Unable to close driver: " + result);
        }
    }

    public void quit() {
        if (this.proxyManager != null) {
            this.proxyManager.restoreRegistrySettings(true);
        }
        if (this.cleanupThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.cleanupThread);
        }
        try {
            for (String handle : this.getWindowHandles()) {
                try {
                    this.switchTo().window(handle);
                    this.close();
                }
                catch (NoSuchWindowException noSuchWindowException) {}
            }
        }
        catch (IllegalStateException e) {
            lib.wdFreeDriver(this.driver);
            this.driver = null;
        }
        lib.wdFreeDriver(this.driver);
        this.driver = null;
    }

    public Set<String> getWindowHandles() {
        PointerByReference rawHandles = new PointerByReference();
        int result = lib.wdGetAllWindowHandles(this.driver, rawHandles);
        this.errors.verifyErrorCode(result, "Unable to obtain all window handles");
        return new StringCollection(lib, rawHandles.getValue()).toSet();
    }

    public String getWindowHandle() {
        PointerByReference handle = new PointerByReference();
        int result = lib.wdGetCurrentWindowHandle(this.driver, handle);
        this.errors.verifyErrorCode(result, "Unable to obtain current window handle");
        return new StringWrapper(lib, handle).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeScript(String script, Object ... args) {
        PointerByReference scriptArgsRef = new PointerByReference();
        int result = lib.wdNewScriptArgs(scriptArgsRef, args.length);
        this.errors.verifyErrorCode(result, "Unable to create new script arguments array");
        Pointer scriptArgs = scriptArgsRef.getValue();
        try {
            this.populateArguments(result, scriptArgs, args);
            script = "(function() { return function(){" + script + "};})();";
            PointerByReference scriptResultRef = new PointerByReference();
            result = lib.wdExecuteScript(this.driver, new WString(script), scriptArgs, scriptResultRef);
            this.errors.verifyErrorCode(result, "Cannot execute script");
            Object object = new JavascriptResultCollection(lib, this).extractReturnValue(scriptResultRef);
            return object;
        }
        finally {
            lib.wdFreeScriptArgs(scriptArgs);
        }
    }

    public boolean isJavascriptEnabled() {
        return true;
    }

    private int populateArguments(int result, Pointer scriptArgs, Object ... args) {
        for (Object arg : args) {
            if (arg instanceof String) {
                result = lib.wdAddStringScriptArg(scriptArgs, new WString((String)arg));
            } else if (arg instanceof Boolean) {
                Boolean param = (Boolean)arg;
                result = lib.wdAddBooleanScriptArg(scriptArgs, param == null || param == false ? 0 : 1);
            } else if (arg instanceof Double || arg instanceof Float) {
                Double number = ((Number)arg).doubleValue();
                result = lib.wdAddDoubleScriptArg(scriptArgs, number);
            } else if (arg instanceof Number) {
                long number = ((Number)arg).longValue();
                result = lib.wdAddNumberScriptArg(scriptArgs, new NativeLong(number));
            } else if (arg instanceof InternetExplorerElement) {
                result = ((InternetExplorerElement)arg).addToScriptArgs(scriptArgs);
            } else {
                throw new IllegalArgumentException("Parameter is not of recognized type: " + arg);
            }
            this.errors.verifyErrorCode(result, "Unable to add argument: " + arg);
        }
        return result;
    }

    public void get(String url) {
        int result = lib.wdGet(this.driver, new WString(url));
        if (result != 0) {
            this.errors.verifyErrorCode(result, String.format("Cannot get \"%s\": %s", url, result));
        }
    }

    public String getCurrentUrl() {
        PointerByReference ptr = new PointerByReference();
        int result = lib.wdGetCurrentUrl(this.driver, ptr);
        if (result != 0) {
            throw new IllegalStateException("Unable to get current URL: " + result);
        }
        return new StringWrapper(lib, ptr).toString();
    }

    public String getTitle() {
        PointerByReference ptr = new PointerByReference();
        int result = lib.wdGetTitle(this.driver, ptr);
        if (result != 0) {
            throw new IllegalStateException("Unable to get title: " + result);
        }
        return new StringWrapper(lib, ptr).toString();
    }

    public boolean getVisible() {
        IntByReference toReturn = new IntByReference();
        int result = lib.wdGetVisible(this.driver, toReturn);
        this.errors.verifyErrorCode(result, "Unable to determine if browser is visible");
        return toReturn.getValue() == 1;
    }

    public void setVisible(boolean visible) {
        int result = lib.wdSetVisible(this.driver, visible ? 1 : 0);
        this.errors.verifyErrorCode(result, "Unable to change the visibility of the browser");
    }

    public List<WebElement> findElements(By by) {
        return new Finder(lib, this, null).findElements(by);
    }

    public WebElement findElement(By by) {
        return new Finder(lib, this, null).findElement(by);
    }

    public String toString() {
        return this.getClass().getName() + ": Implement me!";
    }

    public WebDriver.TargetLocator switchTo() {
        return new InternetExplorerTargetLocator();
    }

    public WebDriver.Navigation navigate() {
        return new InternetExplorerNavigation();
    }

    public WebDriver.Options manage() {
        return new InternetExplorerOptions();
    }

    protected void waitForLoadToComplete() {
        lib.wdWaitForLoadToComplete(this.driver);
    }

    public Pointer getDriverPointer() {
        return this.driver;
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        PointerByReference ptr = new PointerByReference();
        int result = lib.wdCaptureScreenshotAsBase64(this.driver, ptr);
        if (result != 0) {
            throw new IllegalStateException("Unable to capture screenshot: " + result);
        }
        return (X)target.convertFromBase64Png(new StringWrapper(lib, ptr).toString());
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.driver != null) {
            lib.wdFreeDriver(this.driver);
        }
    }

    Pointer getUnderlyingPointer() {
        return this.driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLib() {
        InternetExplorerDriver internetExplorerDriver = this;
        synchronized (internetExplorerDriver) {
            if (lib != null) {
                return;
            }
            File parentDir = TemporaryFilesystem.createTempDir((String)"webdriver", (String)"libs");
            StringBuilder jnaPath = new StringBuilder(System.getProperty("jna.library.path", ""));
            jnaPath.append(File.pathSeparator);
            jnaPath.append(System.getProperty("java.class.path"));
            jnaPath.append(File.pathSeparator);
            jnaPath.append(parentDir.getAbsolutePath());
            jnaPath.append(File.pathSeparator);
            try {
                FileHandler.copyResource((File)parentDir, this.getClass(), (String[])new String[]{"InternetExplorerDriver.dll"});
            }
            catch (IOException e) {
                if (Boolean.getBoolean("webdriver.development")) {
                    System.err.println("Exception unpacking required libraries, but in development mode. Continuing");
                }
                throw new WebDriverException((Throwable)e);
            }
            System.setProperty("jna.library.path", jnaPath.toString());
            try {
                lib = (ExportedWebDriverFunctions)Native.loadLibrary((String)"InternetExplorerDriver", ExportedWebDriverFunctions.class);
            }
            catch (UnsatisfiedLinkError e) {
                System.out.println("new File(\".\").getAbsolutePath() = " + new File(".").getAbsolutePath());
                throw new WebDriverException((Throwable)e);
            }
        }
    }

    private class NullPathCookie
    extends Cookie {
        private final String path;

        private NullPathCookie(String name, String value, String domain, String path, Date expiry) {
            super(name, value, domain, path, expiry);
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }

    private class InternetExplorerTimeouts
    implements WebDriver.Timeouts {
        private InternetExplorerTimeouts() {
        }

        public WebDriver.Timeouts implicitlyWait(long time, TimeUnit unit) {
            NativeLong timeout = new NativeLong(unit.toMillis(time));
            int result = lib.wdSetImplicitWaitTimeout(InternetExplorerDriver.this.driver, timeout);
            InternetExplorerDriver.this.errors.verifyErrorCode(result, "Unable to set implicit wait timeout.");
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternetExplorerOptions
    implements WebDriver.Options {
        private InternetExplorerOptions() {
        }

        public void addCookie(Cookie cookie) {
            StringBuilder sb = new StringBuilder(cookie.getName());
            sb.append("=").append(cookie.getValue()).append("; ");
            if (cookie.getPath() != null && !"".equals(cookie.getPath())) {
                sb.append("path=").append(cookie.getPath()).append("; ");
            }
            if (cookie.getDomain() != null && !"".equals(cookie.getDomain())) {
                String domain = cookie.getDomain();
                int colon = domain.indexOf(":");
                if (colon != -1) {
                    domain = domain.substring(0, colon);
                }
                sb.append("domain=").append(domain).append("; ");
            }
            if (cookie.getExpiry() != null) {
                sb.append("expires=");
                sb.append(new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss z").format(cookie.getExpiry()));
            }
            InternetExplorerDriver.this.executeScript("document.cookie = arguments[0]", sb.toString());
        }

        public void deleteAllCookies() {
            Set<Cookie> cookies = this.getCookies();
            for (Cookie cookie : cookies) {
                this.deleteCookie(cookie);
            }
        }

        public void deleteCookie(Cookie cookie) {
            if (cookie == null) {
                throw new WebDriverException("Cookie to delete cannot be null");
            }
            this.deleteCookieNamed(cookie.getName());
        }

        public void deleteCookieNamed(String name) {
            if (name == null) {
                throw new WebDriverException("Cookie to delete cannot be null");
            }
            int result = lib.wdDeleteCookie(InternetExplorerDriver.this.driver, new WString(name));
            InternetExplorerDriver.this.errors.verifyErrorCode(result, "Cannot delete cookie " + name);
        }

        public Set<Cookie> getCookies() {
            String[] cookies;
            String currentUrl = this.getCurrentHost();
            PointerByReference wrapper = new PointerByReference();
            int result = lib.wdGetCookies(InternetExplorerDriver.this.driver, wrapper);
            InternetExplorerDriver.this.errors.verifyErrorCode(result, "Unable to extract visible cookies");
            HashSet<Cookie> toReturn = new HashSet<Cookie>();
            String allDomainCookies = new StringWrapper(lib, wrapper).toString();
            for (String cookie : cookies = allDomainCookies.split("; ")) {
                String[] parts = cookie.split("=");
                if (parts.length != 2) continue;
                toReturn.add((Cookie)new ReturnedCookie(parts[0], parts[1], currentUrl, "", null, false, currentUrl));
            }
            return toReturn;
        }

        public Cookie getCookieNamed(String name) {
            Set<Cookie> allCookies = this.getCookies();
            for (Cookie cookie : allCookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie;
            }
            return null;
        }

        private String getCurrentHost() {
            try {
                URL url = new URL(InternetExplorerDriver.this.getCurrentUrl());
                return url.getHost();
            }
            catch (MalformedURLException e) {
                return "";
            }
        }

        public Speed getSpeed() {
            return InternetExplorerDriver.this.speed;
        }

        public void setSpeed(Speed speed) {
            InternetExplorerDriver.this.speed = speed;
        }

        public WebDriver.Timeouts timeouts() {
            return new InternetExplorerTimeouts();
        }
    }

    private class InternetExplorerNavigation
    implements WebDriver.Navigation {
        private InternetExplorerNavigation() {
        }

        public void back() {
            int result = lib.wdGoBack(InternetExplorerDriver.this.driver);
            InternetExplorerDriver.this.errors.verifyErrorCode(result, "Unable to go back");
        }

        public void forward() {
            int result = lib.wdGoForward(InternetExplorerDriver.this.driver);
            InternetExplorerDriver.this.errors.verifyErrorCode(result, "Unable to go forward");
        }

        public void to(String url) {
            InternetExplorerDriver.this.get(url);
        }

        public void to(URL url) {
            InternetExplorerDriver.this.get(String.valueOf(url));
        }

        public void refresh() {
            int result = lib.wdRefresh(InternetExplorerDriver.this.driver);
            InternetExplorerDriver.this.errors.verifyErrorCode(result, "Unable to refresh current page");
        }
    }

    private class InternetExplorerTargetLocator
    implements WebDriver.TargetLocator {
        private InternetExplorerTargetLocator() {
        }

        public WebDriver frame(int frameIndex) {
            return this.frame(String.valueOf(frameIndex));
        }

        public WebDriver frame(String frameName) {
            int result = lib.wdSwitchToFrame(InternetExplorerDriver.this.driver, new WString(frameName));
            InternetExplorerDriver.this.errors.verifyErrorCode(result, "Unable to switch to frame: " + frameName);
            return InternetExplorerDriver.this;
        }

        public WebDriver window(String windowName) {
            int result = lib.wdSwitchToWindow(InternetExplorerDriver.this.driver, new WString(windowName));
            InternetExplorerDriver.this.errors.verifyErrorCode(result, "Unable to locate window: " + windowName);
            return InternetExplorerDriver.this;
        }

        public WebDriver defaultContent() {
            return this.frame("");
        }

        public WebElement activeElement() {
            PointerByReference element = new PointerByReference();
            int result = lib.wdSwitchToActiveElement(InternetExplorerDriver.this.driver, element);
            InternetExplorerDriver.this.errors.verifyErrorCode(result, "Unable to find active element");
            return new InternetExplorerElement(lib, InternetExplorerDriver.this, element.getValue());
        }

        public Alert alert() {
            throw new UnsupportedOperationException("alert");
        }
    }
}

