/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.ie.ExportedWebDriverFunctions;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ElementCollection {
    private final List<WebElement> elements;

    public ElementCollection(ExportedWebDriverFunctions lib, InternetExplorerDriver driver, Pointer rawElements) {
        this.elements = this.extractElements(lib, driver, rawElements);
    }

    public List<WebElement> toList() {
        return this.elements;
    }

    private List<WebElement> extractElements(ExportedWebDriverFunctions lib, InternetExplorerDriver driver, Pointer rawElements) {
        IntByReference length = new IntByReference();
        int result = lib.wdcGetElementCollectionLength(rawElements, length);
        if (result != 0) {
            this.freeElements(lib, rawElements);
            throw new IllegalStateException("Cannot extract elements from collection: " + result);
        }
        ArrayList<WebElement> toReturn = new ArrayList<WebElement>(length.getValue());
        for (int i = 0; i < length.getValue(); ++i) {
            PointerByReference element = new PointerByReference();
            result = lib.wdcGetElementAtIndex(rawElements, i, element);
            if (result != 0) {
                this.freeElements(lib, rawElements);
                throw new IllegalStateException(String.format("Cannot extract element from collection at index: %d (%d)", i, result));
            }
            toReturn.add((WebElement)new InternetExplorerElement(lib, driver, element.getValue()));
        }
        this.freeCollection(lib, rawElements);
        return toReturn;
    }

    private void freeElements(ExportedWebDriverFunctions lib, Pointer rawElements) {
        lib.wdFreeElementCollection(rawElements, 1);
    }

    private void freeCollection(ExportedWebDriverFunctions lib, Pointer rawElements) {
        lib.wdFreeElementCollection(rawElements, 0);
    }
}

