/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openqa.selenium.ie.ExportedWebDriverFunctions;
import org.openqa.selenium.ie.StringWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StringCollection {
    private final Set<String> strings;

    public StringCollection(ExportedWebDriverFunctions lib, Pointer rawStrings) {
        this.strings = this.extractStrings(lib, rawStrings);
    }

    public Set<String> toSet() {
        return this.strings;
    }

    private Set<String> extractStrings(ExportedWebDriverFunctions lib, Pointer rawStrings) {
        IntByReference length = new IntByReference();
        int result = lib.wdcGetStringCollectionLength(rawStrings, length);
        if (result != 0) {
            this.freeCollection(lib, rawStrings);
            throw new IllegalStateException("Cannot extract strings from collection: " + result);
        }
        LinkedHashSet<String> toReturn = new LinkedHashSet<String>(length.getValue());
        for (int i = 0; i < length.getValue(); ++i) {
            PointerByReference string = new PointerByReference();
            result = lib.wdcGetStringAtIndex(rawStrings, i, string);
            if (result != 0) {
                this.freeCollection(lib, rawStrings);
                throw new IllegalStateException(String.format("Cannot extract string from collection at index: %d (%d)", i, result));
            }
            String value = new StringWrapper(lib, string).toString();
            toReturn.add(value);
        }
        this.freeCollection(lib, rawStrings);
        return toReturn;
    }

    private void freeCollection(ExportedWebDriverFunctions lib, Pointer rawElements) {
        lib.wdFreeStringCollection(rawElements);
    }
}

