/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.net.ConnectException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.internal.Debug;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;

public class RetryRequest
implements Filter {
    private static final Logger LOG = Logger.getLogger(RetryRequest.class.getName());
    private static final Level LOG_LEVEL = Debug.getDebugLogLevel();
    private static final int RETRIES_ON_CONNECTION_FAILURE = 3;
    private static final int RETRIES_ON_SERVER_ERROR = 2;
    private static final int NEEDED_ATTEMPTS = Math.max(3, 2) + 1;

    @Override
    public HttpHandler apply(HttpHandler next) {
        return req -> {
            for (int i = 0; i < NEEDED_ATTEMPTS; ++i) {
                boolean isServerError;
                HttpResponse response;
                try {
                    response = next.execute(req);
                }
                catch (RuntimeException ex) {
                    boolean isConnectionFailure = ex.getCause() instanceof ConnectException;
                    if (isConnectionFailure && i < 3) {
                        LOG.log(LOG_LEVEL, "Retry #" + (i + 1) + " on ConnectException", ex);
                        continue;
                    }
                    throw ex;
                }
                boolean bl = isServerError = response.getStatus() == 500 && response.getContent().length() == 0L || response.getStatus() == 503;
                if (isServerError && i < 2) {
                    LOG.log(LOG_LEVEL, "Retry #" + (i + 1) + " on ServerError: " + response.getStatus());
                    continue;
                }
                return response;
            }
            throw new IllegalStateException("Effective unreachable code reached, check constants.");
        };
    }
}

