/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;

class FileContentSupplier
implements Contents.Supplier {
    private final File file;
    private volatile InputStream inputStream;

    FileContentSupplier(File file) {
        this.file = (File)Require.nonNull((String)"File", (Object)file);
    }

    @Override
    public synchronized InputStream get() {
        if (this.inputStream != null) {
            throw new IllegalStateException("File input stream has been opened before");
        }
        try {
            this.inputStream = Files.newInputStream(this.file.toPath(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("File not readable: " + this.file.getAbsolutePath(), e);
        }
        return this.inputStream;
    }

    @Override
    public long length() {
        try {
            BasicFileAttributes attributes = Files.readAttributes(this.file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return attributes.size();
        }
        catch (IOException e) {
            throw new IllegalStateException("File not readable: " + this.file.getAbsolutePath(), e);
        }
    }

    @Override
    public void close() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return String.format("Contents.file(%s)", this.file);
    }

    @Override
    public String contentAsString(Charset charset) {
        throw new UnsupportedOperationException("File content may be too large");
    }
}

