/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.io.Closeable;
import java.util.function.Consumer;
import org.openqa.selenium.remote.http.BinaryMessage;
import org.openqa.selenium.remote.http.CloseMessage;
import org.openqa.selenium.remote.http.Message;
import org.openqa.selenium.remote.http.TextMessage;

public interface WebSocket
extends Closeable {
    public WebSocket send(Message var1);

    default public WebSocket sendText(CharSequence data) {
        return this.send(new TextMessage(data));
    }

    default public WebSocket sendBinary(byte[] data) {
        return this.send(new BinaryMessage(data));
    }

    @Override
    public void close();

    public static class Listener
    implements Consumer<Message> {
        @Override
        public void accept(Message message) {
            if (message instanceof BinaryMessage) {
                this.onBinary(((BinaryMessage)message).data());
            } else if (message instanceof CloseMessage) {
                this.onClose(((CloseMessage)message).code(), ((CloseMessage)message).reason());
            } else if (message instanceof TextMessage) {
                this.onText(((TextMessage)message).text());
            }
        }

        public void onBinary(byte[] data) {
        }

        public void onClose(int code, String reason) {
        }

        public void onText(CharSequence data) {
        }

        public void onError(Throwable cause) {
        }
    }
}

