/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.NativeJavaObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;

class AsyncScriptExecutor {
    private final HtmlPage page;
    private final long timeoutMillis;

    AsyncScriptExecutor(HtmlPage page, long timeoutMillis) {
        this.page = page;
        this.timeoutMillis = timeoutMillis;
    }

    public Object execute(String scriptBody, Object[] parameters) {
        AsyncScriptResult asyncResult = new AsyncScriptResult();
        Function function = this.createInjectedScriptFunction(scriptBody, asyncResult);
        try {
            this.page.executeJavaScriptFunctionIfPossible(function, (Scriptable)function, parameters, (DomNode)this.page.getDocumentElement());
        }
        catch (ScriptException e) {
            throw new WebDriverException((Throwable)e);
        }
        try {
            return asyncResult.waitForResult();
        }
        catch (InterruptedException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private Function createInjectedScriptFunction(String userScript, AsyncScriptResult asyncResult) {
        String script = "function() {  var self = this, timeoutId;  var cleanUp = function() {    window.clearTimeout(timeoutId);    if (window.detachEvent) {      window.detachEvent('onunload', catchUnload);    } else {      window.removeEventListener('unload', catchUnload, false);    }  };  var self = this, timeoutId, catchUnload = function() {    cleanUp();    self.host.unload();  };  arguments = Array.prototype.slice.call(arguments, 0);  arguments.push(function(value) {    cleanUp();    self.host.callback(typeof value == 'undefined' ? null : value);  });  if (window.attachEvent) {    window.attachEvent('onunload', catchUnload);  } else {    window.addEventListener('unload', catchUnload, false);  }  (function() {" + userScript + "}).apply(null, arguments);  timeoutId = window.setTimeout(function() {    self.host.timeout();  }, " + this.timeoutMillis + ");}";
        ScriptResult result = this.page.executeJavaScript(script);
        Function function = (Function)result.getJavaScriptResult();
        function.put("host", (Scriptable)function, (Object)new NativeJavaObject((Scriptable)function, (Object)asyncResult, null));
        return function;
    }

    public static class AsyncScriptResult {
        private final CountDownLatch latch = new CountDownLatch(1);
        private volatile Object value = null;
        private volatile boolean isTimeout = false;
        private volatile boolean unloadDetected = false;

        Object waitForResult() throws InterruptedException {
            long startTimeNanos = System.nanoTime();
            this.latch.await();
            if (this.isTimeout) {
                long elapsedTimeNanos = System.nanoTime() - startTimeNanos;
                long elapsedTimeMillis = TimeUnit.NANOSECONDS.toMillis(elapsedTimeNanos);
                throw new TimeoutException("Timed out waiting for async script result after " + elapsedTimeMillis + "ms");
            }
            if (this.unloadDetected) {
                throw new WebDriverException("Detected a page unload event; executeAsyncScript does not work across page loads");
            }
            return this.value;
        }

        public void callback(Object value) {
            if (this.latch.getCount() > 0L) {
                this.value = value;
                this.latch.countDown();
            }
        }

        public void timeout() {
            if (this.latch.getCount() > 0L) {
                this.isTimeout = true;
                this.latch.countDown();
            }
        }

        public void unload() {
            if (this.latch.getCount() > 0L) {
                this.unloadDetected = true;
                this.latch.countDown();
            }
        }
    }
}

