/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.v1_41;

import java.time.Duration;
import java.util.Set;
import java.util.logging.Logger;
import org.openqa.selenium.docker.Container;
import org.openqa.selenium.docker.ContainerConfig;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.docker.ContainerInfo;
import org.openqa.selenium.docker.ContainerLogs;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.docker.DockerProtocol;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.docker.internal.Reference;
import org.openqa.selenium.docker.v1_41.CreateContainer;
import org.openqa.selenium.docker.v1_41.GetContainerLogs;
import org.openqa.selenium.docker.v1_41.InspectContainer;
import org.openqa.selenium.docker.v1_41.IsContainerPresent;
import org.openqa.selenium.docker.v1_41.ListImages;
import org.openqa.selenium.docker.v1_41.PullImage;
import org.openqa.selenium.docker.v1_41.StartContainer;
import org.openqa.selenium.docker.v1_41.StopContainer;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpHandler;

public class V141Docker
implements DockerProtocol {
    static final String DOCKER_API_VERSION = "1.41";
    private static final Logger LOG = Logger.getLogger(V141Docker.class.getName());
    private final ListImages listImages;
    private final PullImage pullImage;
    private final CreateContainer createContainer;
    private final StartContainer startContainer;
    private final StopContainer stopContainer;
    private final IsContainerPresent isContainerPresent;
    private final InspectContainer inspectContainer;
    private final GetContainerLogs containerLogs;

    public V141Docker(HttpHandler client) {
        Require.nonNull((String)"HTTP client", (Object)client);
        this.listImages = new ListImages(client);
        this.pullImage = new PullImage(client);
        this.createContainer = new CreateContainer(this, client);
        this.startContainer = new StartContainer(client);
        this.stopContainer = new StopContainer(client);
        this.isContainerPresent = new IsContainerPresent(client);
        this.inspectContainer = new InspectContainer(client);
        this.containerLogs = new GetContainerLogs(client);
    }

    @Override
    public String version() {
        return DOCKER_API_VERSION;
    }

    @Override
    public Image getImage(String imageName) throws DockerException {
        Require.nonNull((String)"Image name", (Object)imageName);
        Reference ref = Reference.parse(imageName);
        LOG.info("Listing local images: " + ref);
        Set<Image> allImages = this.listImages.apply(ref);
        if (!allImages.isEmpty()) {
            return allImages.iterator().next();
        }
        LOG.info("Pulling " + ref);
        this.pullImage.apply(ref);
        LOG.info("Pull completed. Listing local images again: " + ref);
        allImages = this.listImages.apply(ref);
        if (!allImages.isEmpty()) {
            return allImages.iterator().next();
        }
        throw new DockerException("Pull appears to have succeeded, but image not present locally: " + imageName);
    }

    @Override
    public Container create(ContainerConfig config) {
        Require.nonNull((String)"Container config", (Object)config);
        LOG.fine("Creating container: " + config);
        return this.createContainer.apply(config);
    }

    @Override
    public boolean isContainerPresent(ContainerId id) throws DockerException {
        Require.nonNull((String)"Container id", (Object)id);
        LOG.info("Checking if container is present: " + id);
        return this.isContainerPresent.apply(id);
    }

    @Override
    public void startContainer(ContainerId id) throws DockerException {
        Require.nonNull((String)"Container id", (Object)id);
        LOG.fine("Starting container: " + id);
        this.startContainer.apply(id);
    }

    @Override
    public void stopContainer(ContainerId id, Duration timeout) throws DockerException {
        Require.nonNull((String)"Container id", (Object)id);
        Require.nonNull((String)"Timeout", (Object)timeout);
        LOG.fine("Stopping container: " + id);
        this.stopContainer.apply(id, timeout);
    }

    @Override
    public ContainerInfo inspectContainer(ContainerId id) throws DockerException {
        Require.nonNull((String)"Container id", (Object)id);
        LOG.fine("Inspecting container: " + id);
        return this.inspectContainer.apply(id);
    }

    @Override
    public ContainerLogs getContainerLogs(ContainerId id) throws DockerException {
        Require.nonNull((String)"Container id", (Object)id);
        LOG.info("Getting container logs: " + id);
        return this.containerLogs.apply(id);
    }
}

